// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * The license type to use for Windows VMs. See [Azure Hybrid User
 * Benefits](https://azure.microsoft.com/pricing/hybrid-benefit/faq/) for more details.
 */
public final class LicenseType extends ExpandableStringEnum<LicenseType> {
    /** Static value None for LicenseType. */
    public static final LicenseType NONE = fromString("None");

    /** Static value Windows_Server for LicenseType. */
    public static final LicenseType WINDOWS_SERVER = fromString("Windows_Server");

    /**
     * Creates a new instance of LicenseType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LicenseType() {
    }

    /**
     * Creates or finds a LicenseType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding LicenseType.
     */
    @JsonCreator
    public static LicenseType fromString(String name) {
        return fromString(name, LicenseType.class);
    }

    /**
     * Gets known LicenseType values.
     *
     * @return known LicenseType values.
     */
    public static Collection<LicenseType> values() {
        return values(LicenseType.class);
    }
}
