// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** KEDA (Kubernetes Event-driven Autoscaling) settings for the workload auto-scaler profile. */
@Fluent
public final class ManagedClusterWorkloadAutoScalerProfileKeda {
    /*
     * Whether to enable KEDA.
     */
    @JsonProperty(value = "enabled", required = true)
    private boolean enabled;

    /** Creates an instance of ManagedClusterWorkloadAutoScalerProfileKeda class. */
    public ManagedClusterWorkloadAutoScalerProfileKeda() {
    }

    /**
     * Get the enabled property: Whether to enable KEDA.
     *
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable KEDA.
     *
     * @param enabled the enabled value to set.
     * @return the ManagedClusterWorkloadAutoScalerProfileKeda object itself.
     */
    public ManagedClusterWorkloadAutoScalerProfileKeda withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
