// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.CassandraKeyspaceGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** An Azure Cosmos DB Cassandra keyspace. */
@Fluent
public final class CassandraKeyspaceGetResultsInner extends ArmResourceProperties {
    /*
     * The properties of an Azure Cosmos DB Cassandra keyspace
     */
    @JsonProperty(value = "properties")
    private CassandraKeyspaceGetProperties innerProperties;

    /** Creates an instance of CassandraKeyspaceGetResultsInner class. */
    public CassandraKeyspaceGetResultsInner() {
    }

    /**
     * Get the innerProperties property: The properties of an Azure Cosmos DB Cassandra keyspace.
     *
     * @return the innerProperties value.
     */
    private CassandraKeyspaceGetProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public CassandraKeyspaceGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public CassandraKeyspaceGetResultsInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public CassandraKeyspaceGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the CassandraKeyspaceGetResultsInner object itself.
     */
    public CassandraKeyspaceGetResultsInner withResource(CassandraKeyspaceGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraKeyspaceGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Get the options property: The options property.
     *
     * @return the options value.
     */
    public CassandraKeyspaceGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: The options property.
     *
     * @param options the options value to set.
     * @return the CassandraKeyspaceGetResultsInner object itself.
     */
    public CassandraKeyspaceGetResultsInner withOptions(CassandraKeyspaceGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CassandraKeyspaceGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
