// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.RestorableMongodbDatabasePropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of an Azure Cosmos DB MongoDB database event. */
@Fluent
public final class RestorableMongodbDatabaseProperties {
    /*
     * The resource of an Azure Cosmos DB MongoDB database event
     */
    @JsonProperty(value = "resource")
    private RestorableMongodbDatabasePropertiesResource resource;

    /** Creates an instance of RestorableMongodbDatabaseProperties class. */
    public RestorableMongodbDatabaseProperties() {
    }

    /**
     * Get the resource property: The resource of an Azure Cosmos DB MongoDB database event.
     *
     * @return the resource value.
     */
    public RestorableMongodbDatabasePropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource of an Azure Cosmos DB MongoDB database event.
     *
     * @param resource the resource value to set.
     * @return the RestorableMongodbDatabaseProperties object itself.
     */
    public RestorableMongodbDatabaseProperties withResource(RestorableMongodbDatabasePropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }
}
