// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties for the database account. */
@Fluent
public final class ServiceResourceInner extends ArmProxyResource {
    /*
     * Services response resource.
     */
    @JsonProperty(value = "properties")
    private ServiceResourceProperties properties;

    /** Creates an instance of ServiceResourceInner class. */
    public ServiceResourceInner() {
    }

    /**
     * Get the properties property: Services response resource.
     *
     * @return the properties value.
     */
    public ServiceResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Services response resource.
     *
     * @param properties the properties value to set.
     * @return the ServiceResourceInner object itself.
     */
    public ServiceResourceInner withProperties(ServiceResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
