// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.cosmos.fluent.models.MongoUserDefinitionGetResultsInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The relevant User Definition. */
@Immutable
public final class MongoUserDefinitionListResult {
    /*
     * List of User Definition and their properties
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<MongoUserDefinitionGetResultsInner> value;

    /** Creates an instance of MongoUserDefinitionListResult class. */
    public MongoUserDefinitionListResult() {
    }

    /**
     * Get the value property: List of User Definition and their properties.
     *
     * @return the value value.
     */
    public List<MongoUserDefinitionGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
