/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.AuthorizationRuleInner;
import com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.azure.resourcemanager.eventhubs.implementation.DisasterRecoveryPairingAuthorizationKeyImpl;
import com.azure.resourcemanager.eventhubs.models.AccessRights;
import com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationKey;
import com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRule;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

class DisasterRecoveryPairingAuthorizationRuleImpl
extends WrapperImpl<AuthorizationRuleInner>
implements DisasterRecoveryPairingAuthorizationRule {
    private final EventHubsManager manager;
    private final Ancestors.TwoAncestor ancestor;

    protected DisasterRecoveryPairingAuthorizationRuleImpl(AuthorizationRuleInner inner, EventHubsManager manager) {
        super((Object)inner);
        this.manager = manager;
        this.ancestor = new Ancestors().new Ancestors.TwoAncestor(inner.id());
    }

    public String name() {
        return ((AuthorizationRuleInner)((Object)this.innerModel())).name();
    }

    @Override
    public List<AccessRights> rights() {
        return ((AuthorizationRuleInner)((Object)this.innerModel())).rights();
    }

    @Override
    public Mono<DisasterRecoveryPairingAuthorizationKey> getKeysAsync() {
        return ((EventHubManagementClient)this.manager.serviceClient()).getDisasterRecoveryConfigs().listKeysAsync(this.ancestor().resourceGroupName(), this.ancestor.ancestor2Name(), this.ancestor().ancestor1Name(), this.name()).map(DisasterRecoveryPairingAuthorizationKeyImpl::new);
    }

    @Override
    public DisasterRecoveryPairingAuthorizationKey getKeys() {
        return (DisasterRecoveryPairingAuthorizationKey)this.getKeysAsync().block();
    }

    public EventHubsManager manager() {
        return this.manager;
    }

    private Ancestors.TwoAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }
}

