// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.keyvault.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.keyvault.fluent.models.VaultInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of vaults. */
@Fluent
public final class VaultListResult {
    /*
     * The list of vaults.
     */
    @JsonProperty(value = "value")
    private List<VaultInner> value;

    /*
     * The URL to get the next set of vaults.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The list of vaults.
     *
     * @return the value value.
     */
    public List<VaultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of vaults.
     *
     * @param value the value value to set.
     * @return the VaultListResult object itself.
     */
    public VaultListResult withValue(List<VaultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of vaults.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of vaults.
     *
     * @param nextLink the nextLink value to set.
     * @return the VaultListResult object itself.
     */
    public VaultListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
