/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.loganalytics.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.loganalytics.LogAnalyticsManager;
import com.azure.resourcemanager.loganalytics.fluent.LinkedServicesClient;
import com.azure.resourcemanager.loganalytics.fluent.models.LinkedServiceInner;
import com.azure.resourcemanager.loganalytics.implementation.LinkedServiceImpl;
import com.azure.resourcemanager.loganalytics.implementation.Utils;
import com.azure.resourcemanager.loganalytics.models.LinkedService;
import com.azure.resourcemanager.loganalytics.models.LinkedServices;

public final class LinkedServicesImpl
implements LinkedServices {
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServicesImpl.class);
    private final LinkedServicesClient innerClient;
    private final LogAnalyticsManager serviceManager;

    public LinkedServicesImpl(LinkedServicesClient innerClient, LogAnalyticsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public LinkedService delete(String resourceGroupName, String workspaceName, String linkedServiceName) {
        LinkedServiceInner inner = this.serviceClient().delete(resourceGroupName, workspaceName, linkedServiceName);
        if (inner != null) {
            return new LinkedServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public LinkedService delete(String resourceGroupName, String workspaceName, String linkedServiceName, Context context) {
        LinkedServiceInner inner = this.serviceClient().delete(resourceGroupName, workspaceName, linkedServiceName, context);
        if (inner != null) {
            return new LinkedServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public LinkedService get(String resourceGroupName, String workspaceName, String linkedServiceName) {
        LinkedServiceInner inner = this.serviceClient().get(resourceGroupName, workspaceName, linkedServiceName);
        if (inner != null) {
            return new LinkedServiceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<LinkedService> getWithResponse(String resourceGroupName, String workspaceName, String linkedServiceName, Context context) {
        Response<LinkedServiceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, linkedServiceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new LinkedServiceImpl((LinkedServiceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<LinkedService> listByWorkspace(String resourceGroupName, String workspaceName) {
        PagedIterable<LinkedServiceInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName);
        return Utils.mapPage(inner, inner1 -> new LinkedServiceImpl((LinkedServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LinkedService> listByWorkspace(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<LinkedServiceInner> inner = this.serviceClient().listByWorkspace(resourceGroupName, workspaceName, context);
        return Utils.mapPage(inner, inner1 -> new LinkedServiceImpl((LinkedServiceInner)((Object)inner1), this.manager()));
    }

    @Override
    public LinkedService getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String linkedServiceName = Utils.getValueFromIdByName(id, "linkedServices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedServices'.", id)));
        }
        return (LinkedService)this.getWithResponse(resourceGroupName, workspaceName, linkedServiceName, Context.NONE).getValue();
    }

    @Override
    public Response<LinkedService> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String linkedServiceName = Utils.getValueFromIdByName(id, "linkedServices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedServices'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, linkedServiceName, context);
    }

    @Override
    public LinkedService deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String linkedServiceName = Utils.getValueFromIdByName(id, "linkedServices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedServices'.", id)));
        }
        return this.delete(resourceGroupName, workspaceName, linkedServiceName, Context.NONE);
    }

    @Override
    public LinkedService deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String workspaceName = Utils.getValueFromIdByName(id, "workspaces");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String linkedServiceName = Utils.getValueFromIdByName(id, "linkedServices");
        if (linkedServiceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedServices'.", id)));
        }
        return this.delete(resourceGroupName, workspaceName, linkedServiceName, context);
    }

    private LinkedServicesClient serviceClient() {
        return this.innerClient;
    }

    private LogAnalyticsManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkedServiceImpl define(String name) {
        return new LinkedServiceImpl(name, this.manager());
    }
}

