// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.monitor.fluent.ActionGroupsClient;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupResourceInner;
import com.azure.resourcemanager.monitor.fluent.models.TestNotificationDetailsResponseInner;
import com.azure.resourcemanager.monitor.models.ActionGroupList;
import com.azure.resourcemanager.monitor.models.ActionGroupPatchBody;
import com.azure.resourcemanager.monitor.models.EnableRequest;
import com.azure.resourcemanager.monitor.models.NotificationRequestBody;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ActionGroupsClient. */
public final class ActionGroupsClientImpl
    implements InnerSupportsGet<ActionGroupResourceInner>,
        InnerSupportsListing<ActionGroupResourceInner>,
        InnerSupportsDelete<Void>,
        ActionGroupsClient {
    /** The proxy service used to perform REST calls. */
    private final ActionGroupsService service;

    /** The service client containing this operation class. */
    private final MonitorClientImpl client;

    /**
     * Initializes an instance of ActionGroupsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ActionGroupsClientImpl(MonitorClientImpl client) {
        this.service =
            RestProxy.create(ActionGroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MonitorClientActionGroups to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MonitorClientActionG")
    public interface ActionGroupsService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActionGroupResourceInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ActionGroupResourceInner actionGroup,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActionGroupResourceInner>> getByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActionGroupResourceInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ActionGroupPatchBody actionGroupPatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/createNotifications")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> postTestNotifications(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") NotificationRequestBody notificationRequest,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/createNotifications")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevel(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") NotificationRequestBody notificationRequest,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}/createNotifications")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevel(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") NotificationRequestBody notificationRequest,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/notificationStatus/{notificationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TestNotificationDetailsResponseInner>> getTestNotifications(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("notificationId") String notificationId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/notificationStatus/{notificationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtResourceGroupLevel(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("notificationId") String notificationId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}/notificationStatus/{notificationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtActionGroupResourceLevel(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @PathParam("notificationId") String notificationId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/actionGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActionGroupList>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ActionGroupList>> listByResourceGroup(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights"
                + "/actionGroups/{actionGroupName}/subscribe")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> enableReceiver(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("actionGroupName") String actionGroupName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") EnableRequest enableRequest,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        } else {
            actionGroup.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            actionGroupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            actionGroup,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        } else {
            actionGroup.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                actionGroupName,
                this.client.getSubscriptionId(),
                apiVersion,
                actionGroup,
                accept,
                context);
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> createOrUpdateAsync(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> createOrUpdateWithResponse(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup, context).block();
    }

    /**
     * Create a new action group or update an existing one.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroup The action group to create or use for the update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActionGroupResourceInner createOrUpdate(
        String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return createOrUpdateWithResponse(resourceGroupName, actionGroupName, actionGroup, Context.NONE).getValue();
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            actionGroupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                actionGroupName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> getByResourceGroupWithResponse(
        String resourceGroupName, String actionGroupName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    /**
     * Get an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName) {
        return getByResourceGroupWithResponse(resourceGroupName, actionGroupName, Context.NONE).getValue();
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            actionGroupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                actionGroupName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String actionGroupName) {
        return deleteWithResponseAsync(resourceGroupName, actionGroupName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String actionGroupName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    /**
     * Delete an action group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String actionGroupName) {
        deleteWithResponse(resourceGroupName, actionGroupName, Context.NONE);
    }

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        } else {
            actionGroupPatch.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            actionGroupName,
                            apiVersion,
                            actionGroupPatch,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        } else {
            actionGroupPatch.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                actionGroupName,
                apiVersion,
                actionGroupPatch,
                accept,
                context);
    }

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> updateAsync(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> updateWithResponse(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        return updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch, context).block();
    }

    /**
     * Updates an existing action group's tags. To update other fields use the CreateOrUpdate method.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param actionGroupPatch Parameters supplied to the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an action group resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ActionGroupResourceInner update(
        String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return updateWithResponse(resourceGroupName, actionGroupName, actionGroupPatch, Context.NONE).getValue();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> postTestNotificationsWithResponseAsync(
        NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .postTestNotifications(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            apiVersion,
                            notificationRequest,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> postTestNotificationsWithResponseAsync(
        NotificationRequestBody notificationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .postTestNotifications(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                apiVersion,
                notificationRequest,
                accept,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotificationsAsync(NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = postTestNotificationsWithResponseAsync(notificationRequest);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                this.client.getContext());
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotificationsAsync(NotificationRequestBody notificationRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = postTestNotificationsWithResponseAsync(notificationRequest, context);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotifications(NotificationRequestBody notificationRequest) {
        return beginPostTestNotificationsAsync(notificationRequest).getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginPostTestNotifications(NotificationRequestBody notificationRequest, Context context) {
        return beginPostTestNotificationsAsync(notificationRequest, context).getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> postTestNotificationsAsync(
        NotificationRequestBody notificationRequest) {
        return beginPostTestNotificationsAsync(notificationRequest)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> postTestNotificationsAsync(
        NotificationRequestBody notificationRequest, Context context) {
        return beginPostTestNotificationsAsync(notificationRequest, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner postTestNotifications(NotificationRequestBody notificationRequest) {
        return postTestNotificationsAsync(notificationRequest).block();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner postTestNotifications(
        NotificationRequestBody notificationRequest, Context context) {
        return postTestNotificationsAsync(notificationRequest, context).block();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevelWithResponseAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createNotificationsAtResourceGroupLevel(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            apiVersion,
                            notificationRequest,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevelWithResponseAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createNotificationsAtResourceGroupLevel(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                apiVersion,
                notificationRequest,
                accept,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevelAsync(
            String resourceGroupName, NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationRequest);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                this.client.getContext());
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevelAsync(
            String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationRequest, context);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevel(
            String resourceGroupName, NotificationRequestBody notificationRequest) {
        return beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest)
            .getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtResourceGroupLevel(
            String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context)
            .getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> createNotificationsAtResourceGroupLevelAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest) {
        return beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> createNotificationsAtResourceGroupLevelAsync(
        String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(
        String resourceGroupName, NotificationRequestBody notificationRequest) {
        return createNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest).block();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(
        String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return createNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context).block();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevelWithResponseAsync(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createNotificationsAtActionGroupResourceLevel(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            actionGroupName,
                            apiVersion,
                            notificationRequest,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevelWithResponseAsync(
        String resourceGroupName,
        String actionGroupName,
        NotificationRequestBody notificationRequest,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        } else {
            notificationRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createNotificationsAtActionGroupResourceLevel(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                actionGroupName,
                apiVersion,
                notificationRequest,
                accept,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevelAsync(
            String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createNotificationsAtActionGroupResourceLevelWithResponseAsync(
                resourceGroupName, actionGroupName, notificationRequest);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                this.client.getContext());
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevelAsync(
            String resourceGroupName,
            String actionGroupName,
            NotificationRequestBody notificationRequest,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createNotificationsAtActionGroupResourceLevelWithResponseAsync(
                resourceGroupName, actionGroupName, notificationRequest, context);
        return this
            .client
            .<TestNotificationDetailsResponseInner, TestNotificationDetailsResponseInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                TestNotificationDetailsResponseInner.class,
                TestNotificationDetailsResponseInner.class,
                context);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevel(
            String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return beginCreateNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest)
            .getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner>
        beginCreateNotificationsAtActionGroupResourceLevel(
            String resourceGroupName,
            String actionGroupName,
            NotificationRequestBody notificationRequest,
            Context context) {
        return beginCreateNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest, context)
            .getSyncPoller();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> createNotificationsAtActionGroupResourceLevelAsync(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return beginCreateNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> createNotificationsAtActionGroupResourceLevelAsync(
        String resourceGroupName,
        String actionGroupName,
        NotificationRequestBody notificationRequest,
        Context context) {
        return beginCreateNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(
        String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return createNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest)
            .block();
    }

    /**
     * Send test notifications to a set of provided receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationRequest The notification request body which includes the contact details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the test notification results.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(
        String resourceGroupName,
        String actionGroupName,
        NotificationRequestBody notificationRequest,
        Context context) {
        return createNotificationsAtActionGroupResourceLevelAsync(
                resourceGroupName, actionGroupName, notificationRequest, context)
            .block();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsWithResponseAsync(
        String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTestNotifications(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            notificationId,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsWithResponseAsync(
        String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTestNotifications(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                notificationId,
                apiVersion,
                accept,
                context);
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAsync(String notificationId) {
        return getTestNotificationsWithResponseAsync(notificationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsWithResponse(
        String notificationId, Context context) {
        return getTestNotificationsWithResponseAsync(notificationId, context).block();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotifications(String notificationId) {
        return getTestNotificationsWithResponse(notificationId, Context.NONE).getValue();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>>
        getTestNotificationsAtResourceGroupLevelWithResponseAsync(String resourceGroupName, String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTestNotificationsAtResourceGroupLevel(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            notificationId,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>>
        getTestNotificationsAtResourceGroupLevelWithResponseAsync(
            String resourceGroupName, String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTestNotificationsAtResourceGroupLevel(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                notificationId,
                apiVersion,
                accept,
                context);
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelAsync(
        String resourceGroupName, String notificationId) {
        return getTestNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelWithResponse(
        String resourceGroupName, String notificationId, Context context) {
        return getTestNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationId, context)
            .block();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotificationsAtResourceGroupLevel(
        String resourceGroupName, String notificationId) {
        return getTestNotificationsAtResourceGroupLevelWithResponse(resourceGroupName, notificationId, Context.NONE)
            .getValue();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>>
        getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(
            String resourceGroupName, String actionGroupName, String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getTestNotificationsAtActionGroupResourceLevel(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            actionGroupName,
                            notificationId,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>>
        getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(
            String resourceGroupName, String actionGroupName, String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error(new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getTestNotificationsAtActionGroupResourceLevel(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                actionGroupName,
                notificationId,
                apiVersion,
                accept,
                context);
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelAsync(
        String resourceGroupName, String actionGroupName, String notificationId) {
        return getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(
                resourceGroupName, actionGroupName, notificationId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelWithResponse(
        String resourceGroupName, String actionGroupName, String notificationId, Context context) {
        return getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(
                resourceGroupName, actionGroupName, notificationId, context)
            .block();
    }

    /**
     * Get the test notifications by the notification id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param notificationId The notification id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the test notifications by the notification id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotificationsAtActionGroupResourceLevel(
        String resourceGroupName, String actionGroupName, String notificationId) {
        return getTestNotificationsAtActionGroupResourceLevelWithResponse(
                resourceGroupName, actionGroupName, notificationId, Context.NONE)
            .getValue();
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context))
            .<PagedResponse<ActionGroupResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ActionGroupResourceInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync());
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ActionGroupResourceInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context));
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get a list of all action groups in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByResourceGroup(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<ActionGroupResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group along with {@link PagedResponse} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(
        String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(
                this.client.getEndpoint(),
                resourceGroupName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Get a list of all action groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all action groups in a resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> enableReceiverWithResponseAsync(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (enableRequest == null) {
            return Mono.error(new IllegalArgumentException("Parameter enableRequest is required and cannot be null."));
        } else {
            enableRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .enableReceiver(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            actionGroupName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            enableRequest,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> enableReceiverWithResponseAsync(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (enableRequest == null) {
            return Mono.error(new IllegalArgumentException("Parameter enableRequest is required and cannot be null."));
        } else {
            enableRequest.validate();
        }
        final String apiVersion = "2022-06-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .enableReceiver(
                this.client.getEndpoint(),
                resourceGroupName,
                actionGroupName,
                this.client.getSubscriptionId(),
                apiVersion,
                enableRequest,
                accept,
                context);
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> enableReceiverAsync(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        return enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, enableRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> enableReceiverWithResponse(
        String resourceGroupName, String actionGroupName, EnableRequest enableRequest, Context context) {
        return enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, enableRequest, context).block();
    }

    /**
     * Enable a receiver in an action group. This changes the receiver's status from Disabled to Enabled. This operation
     * is only supported for Email or SMS receivers.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param actionGroupName The name of the action group.
     * @param enableRequest The receiver to re-enable.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void enableReceiver(String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        enableReceiverWithResponse(resourceGroupName, actionGroupName, enableRequest, Context.NONE);
    }
}
