// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The action that is performed when the alert rule becomes active, and when an alert condition is resolved. */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "odata.type",
    defaultImpl = RuleAction.class)
@JsonTypeName("RuleAction")
@JsonSubTypes({
    @JsonSubTypes.Type(
        name = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction",
        value = RuleEmailAction.class),
    @JsonSubTypes.Type(
        name = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction",
        value = RuleWebhookAction.class)
})
@Immutable
public class RuleAction {
    /** Creates an instance of RuleAction class. */
    public RuleAction() {
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
