/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.azure.resourcemanager.monitor.models.PredictiveAutoscalePolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AutoscaleSetting {
    @JsonProperty(value="profiles", required=true)
    private List<AutoscaleProfileInner> profiles;
    @JsonProperty(value="notifications")
    private List<AutoscaleNotification> notifications;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="predictiveAutoscalePolicy")
    private PredictiveAutoscalePolicy predictiveAutoscalePolicy;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="targetResourceUri")
    private String targetResourceUri;
    @JsonProperty(value="targetResourceLocation")
    private String targetResourceLocation;
    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleSetting.class);

    public List<AutoscaleProfileInner> profiles() {
        return this.profiles;
    }

    public AutoscaleSetting withProfiles(List<AutoscaleProfileInner> profiles) {
        this.profiles = profiles;
        return this;
    }

    public List<AutoscaleNotification> notifications() {
        return this.notifications;
    }

    public AutoscaleSetting withNotifications(List<AutoscaleNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public AutoscaleSetting withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PredictiveAutoscalePolicy predictiveAutoscalePolicy() {
        return this.predictiveAutoscalePolicy;
    }

    public AutoscaleSetting withPredictiveAutoscalePolicy(PredictiveAutoscalePolicy predictiveAutoscalePolicy) {
        this.predictiveAutoscalePolicy = predictiveAutoscalePolicy;
        return this;
    }

    public String name() {
        return this.name;
    }

    public AutoscaleSetting withName(String name) {
        this.name = name;
        return this;
    }

    public String targetResourceUri() {
        return this.targetResourceUri;
    }

    public AutoscaleSetting withTargetResourceUri(String targetResourceUri) {
        this.targetResourceUri = targetResourceUri;
        return this;
    }

    public String targetResourceLocation() {
        return this.targetResourceLocation;
    }

    public AutoscaleSetting withTargetResourceLocation(String targetResourceLocation) {
        this.targetResourceLocation = targetResourceLocation;
        return this;
    }

    public void validate() {
        if (this.profiles() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property profiles in model AutoscaleSetting"));
        }
        this.profiles().forEach(e -> e.validate());
        if (this.notifications() != null) {
            this.notifications().forEach(e -> e.validate());
        }
        if (this.predictiveAutoscalePolicy() != null) {
            this.predictiveAutoscalePolicy().validate();
        }
    }
}

