/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VipSwapsClient;
import com.azure.resourcemanager.network.fluent.models.SwapResourceInner;
import com.azure.resourcemanager.network.fluent.models.SwapResourceListResultInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VipSwapsClientImpl
implements VipSwapsClient {
    private final VipSwapsService service;
    private final NetworkManagementClientImpl client;

    VipSwapsClientImpl(NetworkManagementClientImpl client) {
        this.service = (VipSwapsService)RestProxy.create(VipSwapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SwapResourceInner>> getWithResponseAsync(String groupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String singletonResource = "swap";
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), groupName, resourceName, "swap", "2022-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SwapResourceInner>> getWithResponseAsync(String groupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String singletonResource = "swap";
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), groupName, resourceName, "swap", "2022-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SwapResourceInner> getAsync(String groupName, String resourceName) {
        return this.getWithResponseAsync(groupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((SwapResourceInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SwapResourceInner> getWithResponse(String groupName, String resourceName, Context context) {
        return (Response)this.getWithResponseAsync(groupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SwapResourceInner get(String groupName, String resourceName) {
        return (SwapResourceInner)this.getWithResponse(groupName, resourceName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String groupName, String resourceName, SwapResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String singletonResource = "swap";
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), groupName, resourceName, "swap", "2022-07-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String groupName, String resourceName, SwapResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String singletonResource = "swap";
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), groupName, resourceName, "swap", "2022-07-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginCreateAsync(String groupName, String resourceName, SwapResourceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(groupName, resourceName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCreateAsync(String groupName, String resourceName, SwapResourceInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(groupName, resourceName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreate(String groupName, String resourceName, SwapResourceInner parameters) {
        return this.beginCreateAsync(groupName, resourceName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreate(String groupName, String resourceName, SwapResourceInner parameters, Context context) {
        return this.beginCreateAsync(groupName, resourceName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String groupName, String resourceName, SwapResourceInner parameters) {
        return this.beginCreateAsync(groupName, resourceName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> createAsync(String groupName, String resourceName, SwapResourceInner parameters, Context context) {
        return this.beginCreateAsync(groupName, resourceName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String groupName, String resourceName, SwapResourceInner parameters) {
        this.createAsync(groupName, resourceName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String groupName, String resourceName, SwapResourceInner parameters, Context context) {
        this.createAsync(groupName, resourceName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SwapResourceListResultInner>> listWithResponseAsync(String groupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), groupName, resourceName, "2022-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SwapResourceListResultInner>> listWithResponseAsync(String groupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), groupName, resourceName, "2022-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SwapResourceListResultInner> listAsync(String groupName, String resourceName) {
        return this.listWithResponseAsync(groupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((SwapResourceListResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SwapResourceListResultInner> listWithResponse(String groupName, String resourceName, Context context) {
        return (Response)this.listWithResponseAsync(groupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SwapResourceListResultInner list(String groupName, String resourceName) {
        return (SwapResourceListResultInner)this.listWithResponse(groupName, resourceName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface VipSwapsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Compute/cloudServices/{resourceName}/providers/Microsoft.Network/cloudServiceSlots/{singletonResource}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SwapResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="groupName") String var2, @PathParam(value="resourceName") String var3, @PathParam(value="singletonResource") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Compute/cloudServices/{resourceName}/providers/Microsoft.Network/cloudServiceSlots/{singletonResource}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="groupName") String var2, @PathParam(value="resourceName") String var3, @PathParam(value="singletonResource") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") SwapResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Compute/cloudServices/{resourceName}/providers/Microsoft.Network/cloudServiceSlots")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SwapResourceListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="groupName") String var2, @PathParam(value="resourceName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

