// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.servicebus.models.EntityStatus;
import com.azure.resourcemanager.servicebus.models.MessageCountDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;

/** Description of topic resource. */
@Fluent
public final class SBTopicInner extends Resource {
    /*
     * Properties of topic resource.
     */
    @JsonProperty(value = "properties")
    private SBTopicProperties innerProperties;

    /*
     * The system meta data relating to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * The geo-location where the resource lives
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * Get the innerProperties property: Properties of topic resource.
     *
     * @return the innerProperties value.
     */
    private SBTopicProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system meta data relating to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the location property: The geo-location where the resource lives.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the sizeInBytes property: Size of the topic, in bytes.
     *
     * @return the sizeInBytes value.
     */
    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    /**
     * Get the createdAt property: Exact time the message was created.
     *
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    /**
     * Get the updatedAt property: The exact time the message was updated.
     *
     * @return the updatedAt value.
     */
    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    /**
     * Get the accessedAt property: Last time the message was sent, or a request was received, for this topic.
     *
     * @return the accessedAt value.
     */
    public OffsetDateTime accessedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().accessedAt();
    }

    /**
     * Get the subscriptionCount property: Number of subscriptions.
     *
     * @return the subscriptionCount value.
     */
    public Integer subscriptionCount() {
        return this.innerProperties() == null ? null : this.innerProperties().subscriptionCount();
    }

    /**
     * Get the countDetails property: Message count details.
     *
     * @return the countDetails value.
     */
    public MessageCountDetails countDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().countDetails();
    }

    /**
     * Get the defaultMessageTimeToLive property: ISO 8601 Default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     *
     * @return the defaultMessageTimeToLive value.
     */
    public Duration defaultMessageTimeToLive() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultMessageTimeToLive();
    }

    /**
     * Set the defaultMessageTimeToLive property: ISO 8601 Default message timespan to live value. This is the duration
     * after which the message expires, starting from when the message is sent to Service Bus. This is the default value
     * used when TimeToLive is not set on a message itself.
     *
     * @param defaultMessageTimeToLive the defaultMessageTimeToLive value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withDefaultMessageTimeToLive(defaultMessageTimeToLive);
        return this;
    }

    /**
     * Get the maxSizeInMegabytes property: Maximum size of the topic in megabytes, which is the size of the memory
     * allocated for the topic. Default is 1024.
     *
     * @return the maxSizeInMegabytes value.
     */
    public Integer maxSizeInMegabytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeInMegabytes();
    }

    /**
     * Set the maxSizeInMegabytes property: Maximum size of the topic in megabytes, which is the size of the memory
     * allocated for the topic. Default is 1024.
     *
     * @param maxSizeInMegabytes the maxSizeInMegabytes value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withMaxSizeInMegabytes(maxSizeInMegabytes);
        return this;
    }

    /**
     * Get the maxMessageSizeInKilobytes property: Maximum size (in KB) of the message payload that can be accepted by
     * the topic. This property is only used in Premium today and default is 1024.
     *
     * @return the maxMessageSizeInKilobytes value.
     */
    public Long maxMessageSizeInKilobytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxMessageSizeInKilobytes();
    }

    /**
     * Set the maxMessageSizeInKilobytes property: Maximum size (in KB) of the message payload that can be accepted by
     * the topic. This property is only used in Premium today and default is 1024.
     *
     * @param maxMessageSizeInKilobytes the maxMessageSizeInKilobytes value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withMaxMessageSizeInKilobytes(maxMessageSizeInKilobytes);
        return this;
    }

    /**
     * Get the requiresDuplicateDetection property: Value indicating if this topic requires duplicate detection.
     *
     * @return the requiresDuplicateDetection value.
     */
    public Boolean requiresDuplicateDetection() {
        return this.innerProperties() == null ? null : this.innerProperties().requiresDuplicateDetection();
    }

    /**
     * Set the requiresDuplicateDetection property: Value indicating if this topic requires duplicate detection.
     *
     * @param requiresDuplicateDetection the requiresDuplicateDetection value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withRequiresDuplicateDetection(requiresDuplicateDetection);
        return this;
    }

    /**
     * Get the duplicateDetectionHistoryTimeWindow property: ISO8601 timespan structure that defines the duration of the
     * duplicate detection history. The default value is 10 minutes.
     *
     * @return the duplicateDetectionHistoryTimeWindow value.
     */
    public Duration duplicateDetectionHistoryTimeWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().duplicateDetectionHistoryTimeWindow();
    }

    /**
     * Set the duplicateDetectionHistoryTimeWindow property: ISO8601 timespan structure that defines the duration of the
     * duplicate detection history. The default value is 10 minutes.
     *
     * @param duplicateDetectionHistoryTimeWindow the duplicateDetectionHistoryTimeWindow value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withDuplicateDetectionHistoryTimeWindow(duplicateDetectionHistoryTimeWindow);
        return this;
    }

    /**
     * Get the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     *
     * @return the enableBatchedOperations value.
     */
    public Boolean enableBatchedOperations() {
        return this.innerProperties() == null ? null : this.innerProperties().enableBatchedOperations();
    }

    /**
     * Set the enableBatchedOperations property: Value that indicates whether server-side batched operations are
     * enabled.
     *
     * @param enableBatchedOperations the enableBatchedOperations value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withEnableBatchedOperations(Boolean enableBatchedOperations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnableBatchedOperations(enableBatchedOperations);
        return this;
    }

    /**
     * Get the status property: Enumerates the possible values for the status of a messaging entity.
     *
     * @return the status value.
     */
    public EntityStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Enumerates the possible values for the status of a messaging entity.
     *
     * @param status the status value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withStatus(EntityStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the supportOrdering property: Value that indicates whether the topic supports ordering.
     *
     * @return the supportOrdering value.
     */
    public Boolean supportOrdering() {
        return this.innerProperties() == null ? null : this.innerProperties().supportOrdering();
    }

    /**
     * Set the supportOrdering property: Value that indicates whether the topic supports ordering.
     *
     * @param supportOrdering the supportOrdering value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withSupportOrdering(Boolean supportOrdering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withSupportOrdering(supportOrdering);
        return this;
    }

    /**
     * Get the autoDeleteOnIdle property: ISO 8601 timespan idle interval after which the topic is automatically
     * deleted. The minimum duration is 5 minutes.
     *
     * @return the autoDeleteOnIdle value.
     */
    public Duration autoDeleteOnIdle() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDeleteOnIdle();
    }

    /**
     * Set the autoDeleteOnIdle property: ISO 8601 timespan idle interval after which the topic is automatically
     * deleted. The minimum duration is 5 minutes.
     *
     * @param autoDeleteOnIdle the autoDeleteOnIdle value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    /**
     * Get the enablePartitioning property: Value that indicates whether the topic to be partitioned across multiple
     * message brokers is enabled.
     *
     * @return the enablePartitioning value.
     */
    public Boolean enablePartitioning() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePartitioning();
    }

    /**
     * Set the enablePartitioning property: Value that indicates whether the topic to be partitioned across multiple
     * message brokers is enabled.
     *
     * @param enablePartitioning the enablePartitioning value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withEnablePartitioning(Boolean enablePartitioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnablePartitioning(enablePartitioning);
        return this;
    }

    /**
     * Get the enableExpress property: Value that indicates whether Express Entities are enabled. An express topic holds
     * a message in memory temporarily before writing it to persistent storage.
     *
     * @return the enableExpress value.
     */
    public Boolean enableExpress() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExpress();
    }

    /**
     * Set the enableExpress property: Value that indicates whether Express Entities are enabled. An express topic holds
     * a message in memory temporarily before writing it to persistent storage.
     *
     * @param enableExpress the enableExpress value to set.
     * @return the SBTopicInner object itself.
     */
    public SBTopicInner withEnableExpress(Boolean enableExpress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBTopicProperties();
        }
        this.innerProperties().withEnableExpress(enableExpress);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
