// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The replication policy between two storage accounts. Multiple rules can be defined in one policy. */
@Fluent
public final class ObjectReplicationPolicyInner extends ProxyResource {
    /*
     * Returns the Storage Account Object Replication Policy.
     */
    @JsonProperty(value = "properties")
    private ObjectReplicationPolicyProperties innerProperties;

    /**
     * Get the innerProperties property: Returns the Storage Account Object Replication Policy.
     *
     * @return the innerProperties value.
     */
    private ObjectReplicationPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the policyId property: A unique id for object replication policy.
     *
     * @return the policyId value.
     */
    public String policyId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyId();
    }

    /**
     * Get the enabledTime property: Indicates when the policy is enabled on the source account.
     *
     * @return the enabledTime value.
     */
    public OffsetDateTime enabledTime() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledTime();
    }

    /**
     * Get the sourceAccount property: Required. Source account name. It should be full resource id if
     * allowCrossTenantReplication set to false.
     *
     * @return the sourceAccount value.
     */
    public String sourceAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAccount();
    }

    /**
     * Set the sourceAccount property: Required. Source account name. It should be full resource id if
     * allowCrossTenantReplication set to false.
     *
     * @param sourceAccount the sourceAccount value to set.
     * @return the ObjectReplicationPolicyInner object itself.
     */
    public ObjectReplicationPolicyInner withSourceAccount(String sourceAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withSourceAccount(sourceAccount);
        return this;
    }

    /**
     * Get the destinationAccount property: Required. Destination account name. It should be full resource id if
     * allowCrossTenantReplication set to false.
     *
     * @return the destinationAccount value.
     */
    public String destinationAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAccount();
    }

    /**
     * Set the destinationAccount property: Required. Destination account name. It should be full resource id if
     * allowCrossTenantReplication set to false.
     *
     * @param destinationAccount the destinationAccount value to set.
     * @return the ObjectReplicationPolicyInner object itself.
     */
    public ObjectReplicationPolicyInner withDestinationAccount(String destinationAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withDestinationAccount(destinationAccount);
        return this;
    }

    /**
     * Get the rules property: The storage account object replication rules.
     *
     * @return the rules value.
     */
    public List<ObjectReplicationPolicyRule> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: The storage account object replication rules.
     *
     * @param rules the rules value to set.
     * @return the ObjectReplicationPolicyInner object itself.
     */
    public ObjectReplicationPolicyInner withRules(List<ObjectReplicationPolicyRule> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ObjectReplicationPolicyProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
