// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.resourcemanager.trafficmanager.models.HeatMapEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficFlow;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Class representing a Traffic Manager HeatMap. */
@Fluent
public final class HeatMapModelInner extends ProxyResource {
    /*
     * The properties of the Traffic Manager HeatMap.
     */
    @JsonProperty(value = "properties")
    private HeatMapProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The name of the resource
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    @JsonProperty(value = "type")
    private String type;

    /** Creates an instance of HeatMapModelInner class. */
    public HeatMapModelInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Traffic Manager HeatMap.
     *
     * @return the innerProperties value.
     */
    private HeatMapProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Fully qualified resource Id for the resource. Ex -
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}.
     *
     * @param id the id value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource.
     *
     * @param name the name value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     *
     * @param type the type value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the startTime property: The beginning of the time window for this HeatMap, inclusive.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: The beginning of the time window for this HeatMap, inclusive.
     *
     * @param startTime the startTime value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HeatMapProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the endTime property: The ending of the time window for this HeatMap, exclusive.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Set the endTime property: The ending of the time window for this HeatMap, exclusive.
     *
     * @param endTime the endTime value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HeatMapProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    /**
     * Get the endpoints property: The endpoints used in this HeatMap calculation.
     *
     * @return the endpoints value.
     */
    public List<HeatMapEndpoint> endpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoints();
    }

    /**
     * Set the endpoints property: The endpoints used in this HeatMap calculation.
     *
     * @param endpoints the endpoints value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withEndpoints(List<HeatMapEndpoint> endpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HeatMapProperties();
        }
        this.innerProperties().withEndpoints(endpoints);
        return this;
    }

    /**
     * Get the trafficFlows property: The traffic flows produced in this HeatMap calculation.
     *
     * @return the trafficFlows value.
     */
    public List<TrafficFlow> trafficFlows() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficFlows();
    }

    /**
     * Set the trafficFlows property: The traffic flows produced in this HeatMap calculation.
     *
     * @param trafficFlows the trafficFlows value to set.
     * @return the HeatMapModelInner object itself.
     */
    public HeatMapModelInner withTrafficFlows(List<TrafficFlow> trafficFlows) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HeatMapProperties();
        }
        this.innerProperties().withTrafficFlows(trafficFlows);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
