// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.trafficmanager.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Class representing a Traffic Manager Real User Metrics key response. */
@Fluent
public final class UserMetricsProperties {
    /*
     * The key returned by the User Metrics operation.
     */
    @JsonProperty(value = "key")
    private String key;

    /** Creates an instance of UserMetricsProperties class. */
    public UserMetricsProperties() {
    }

    /**
     * Get the key property: The key returned by the User Metrics operation.
     *
     * @return the key value.
     */
    public String key() {
        return this.key;
    }

    /**
     * Set the key property: The key returned by the User Metrics operation.
     *
     * @param key the key value to set.
     * @return the UserMetricsProperties object itself.
     */
    public UserMetricsProperties withKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
