/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.config.properties;

import com.azure.spring.cloud.config.properties.AppConfigurationStoreTrigger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.util.Assert;

public final class AppConfigurationStoreMonitoring {
    private boolean enabled = false;
    private Duration refreshInterval = Duration.ofSeconds(30L);
    private Duration featureFlagRefreshInterval = Duration.ofSeconds(30L);
    private List<AppConfigurationStoreTrigger> triggers = new ArrayList<AppConfigurationStoreTrigger>();
    private PushNotification pushNotification = new PushNotification();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(Duration refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Duration getFeatureFlagRefreshInterval() {
        return this.featureFlagRefreshInterval;
    }

    public void setFeatureFlagRefreshInterval(Duration featureFlagRefreshInterval) {
        this.featureFlagRefreshInterval = featureFlagRefreshInterval;
    }

    public List<AppConfigurationStoreTrigger> getTriggers() {
        return this.triggers;
    }

    public void setTriggers(List<AppConfigurationStoreTrigger> triggers) {
        this.triggers = triggers;
    }

    public PushNotification getPushNotification() {
        return this.pushNotification;
    }

    public void setPushNotification(PushNotification pushNotification) {
        this.pushNotification = pushNotification;
    }

    @PostConstruct
    public void validateAndInit() {
        if (this.enabled) {
            Assert.notEmpty(this.triggers, (String)"Triggers need to be set if refresh is enabled.");
            for (AppConfigurationStoreTrigger trigger : this.triggers) {
                trigger.validateAndInit();
            }
        }
        Assert.isTrue((this.refreshInterval.getSeconds() >= 1L ? 1 : 0) != 0, (String)"Minimum refresh interval time is 1 Second.");
        Assert.isTrue((this.featureFlagRefreshInterval.getSeconds() >= 1L ? 1 : 0) != 0, (String)"Minimum Feature Flag refresh interval time is 1 Second.");
    }

    public static class AccessToken {
        private String name;
        private String secret;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public boolean isValid() {
            return this.name != null && this.secret != null;
        }
    }

    public static class PushNotification {
        private AccessToken primaryToken = new AccessToken();
        private AccessToken secondaryToken = new AccessToken();

        public AccessToken getPrimaryToken() {
            return this.primaryToken;
        }

        public void setPrimaryToken(AccessToken primaryToken) {
            this.primaryToken = primaryToken;
        }

        public AccessToken getSecondaryToken() {
            return this.secondaryToken;
        }

        public void setSecondaryToken(AccessToken secondaryToken) {
            this.secondaryToken = secondaryToken;
        }
    }
}

