/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.window.groupconcat;

import com.blazebit.persistence.impl.function.Order;
import com.blazebit.persistence.impl.function.window.AbstractWindowFunction;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public abstract class AbstractGroupConcatWindowFunction
extends AbstractWindowFunction
implements JpqlFunction {
    public AbstractGroupConcatWindowFunction(String functionName, boolean nullIsSmallest, boolean supportsNullPrecedence, boolean supportsFilterClause, boolean allowsFilterClause) {
        super(functionName, nullIsSmallest, supportsNullPrecedence, supportsFilterClause, allowsFilterClause);
    }

    @Override
    public boolean hasArguments() {
        return true;
    }

    @Override
    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    @Override
    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    @Override
    protected GroupConcat getWindowFunction(FunctionRenderContext context) {
        if (context.getArgumentsSize() == 0) {
            throw new RuntimeException("The group concat function needs at least one argument! args=" + context);
        }
        return this.getWindowFunction(context, new GroupConcat(this.functionName), 0);
    }

    @Override
    protected Enum<?> processArgument(Enum<?> mode, AbstractWindowFunction.WindowFunction windowFunction, String argument) {
        if (mode == Mode.SEPARATOR) {
            if (!"'SEPARATOR'".equalsIgnoreCase(argument)) {
                GroupConcat groupConcat = (GroupConcat)windowFunction;
                if (groupConcat.separator != null) {
                    throw new IllegalArgumentException("Illegal multiple separators for group concat '" + argument + "'. Expected 'ORDER BY'!");
                }
                groupConcat.separator = argument.substring(argument.indexOf(39) + 1, argument.lastIndexOf(39));
            }
            return null;
        }
        super.processArgument(mode, windowFunction, argument);
        return Mode.SEPARATOR;
    }

    protected void render(StringBuilder sb, Order order) {
        sb.append(order.getExpression());
        if (order.isAscending()) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        if (order.isNullsFirst()) {
            sb.append(" NULLS FIRST");
        } else {
            sb.append(" NULLS LAST");
        }
    }

    protected String quoted(String s) {
        StringBuilder sb = new StringBuilder();
        TypeUtils.STRING_CONVERTER.appendTo((Object)s, sb);
        return sb.toString();
    }

    protected static final class GroupConcat
    extends AbstractWindowFunction.WindowFunction {
        private String separator;

        public GroupConcat(String functionName) {
            super(functionName);
        }

        public String getSeparator() {
            return this.separator == null ? "," : this.separator;
        }
    }

    private static enum Mode {
        SEPARATOR,
        ORDER_BY;

    }
}

