/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapEntryAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class PathTargetResolvingExpressionVisitor
implements Expression.Visitor {
    private static final Class[] EMPTY = new Class[0];
    protected PathPosition currentPosition;
    protected List<PathPosition> pathPositions;
    protected final EntityMetamodel metamodel;
    protected final Type<?> rootType;
    protected final Attribute<?, ?> rootAttribute;
    protected final Map<String, Type<?>> rootTypes;

    public PathTargetResolvingExpressionVisitor(EntityMetamodel metamodel, Type<?> rootType, String skipBaseNodeAlias) {
        this(metamodel, rootType, null, skipBaseNodeAlias, Collections.emptyMap());
    }

    public PathTargetResolvingExpressionVisitor(EntityMetamodel metamodel, Type<?> rootType, Attribute<?, ?> rootAttribute, String skipBaseNodeAlias, Map<String, Type<?>> rootTypes) {
        this.metamodel = metamodel;
        this.pathPositions = new ArrayList<PathPosition>();
        this.rootType = rootType;
        this.rootAttribute = rootAttribute;
        this.rootTypes = PathTargetResolvingExpressionVisitor.withRootType(rootTypes, rootType, skipBaseNodeAlias);
        this.clear();
    }

    private static Map<String, Type<?>> withRootType(Map<String, Type<?>> rootTypes, Type<?> rootType, String rootAlias) {
        HashMap newRootTypes = new HashMap();
        if (rootTypes != null) {
            newRootTypes.putAll(rootTypes);
        }
        newRootTypes.put("this", rootType);
        if (rootAlias != null) {
            newRootTypes.put(rootAlias, rootType);
        }
        return Collections.unmodifiableMap(newRootTypes);
    }

    public void clear() {
        this.pathPositions.clear();
        this.currentPosition = new PathPosition(this.rootType, this.rootAttribute);
        this.pathPositions.add(this.currentPosition);
    }

    private Type<?> getType(Type<?> baseType, Attribute<?, ?> attribute) {
        Class<?> clazz;
        if (attribute instanceof PluralAttribute) {
            return this.metamodel.type(((PluralAttribute)attribute).getJavaType());
        }
        Class baseClass = baseType.getJavaType();
        if (baseClass != null && (clazz = JpaMetamodelUtils.resolveFieldClass(baseType.getJavaType(), attribute)) != null) {
            return this.metamodel.type(clazz);
        }
        return ((SingularAttribute)attribute).getType();
    }

    public Map<Attribute<?, ?>, Type<?>> getPossibleTargets() {
        HashMap possibleTargets = new HashMap();
        List<PathPosition> positions = this.pathPositions;
        int size = positions.size();
        for (int i = 0; i < size; ++i) {
            PathPosition position = positions.get(i);
            possibleTargets.put(position.getAttribute(), position.getCurrentType());
        }
        return possibleTargets;
    }

    @Override
    public void visit(PropertyExpression expression) {
        String property = expression.getProperty();
        if (this.currentPosition.getCurrentType().getPersistenceType() == Type.PersistenceType.BASIC) {
            throw new IllegalArgumentException("Can't access property '" + property + "' on basic type '" + JpaMetamodelUtils.getTypeName(this.currentPosition.getCurrentType()) + "'. Did you forget to add the embeddable type to your persistence.xml?");
        }
        Attribute attribute = JpaMetamodelUtils.getAttribute((ManagedType)this.currentPosition.getCurrentType(), property);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + property + "' not found on type '" + JpaMetamodelUtils.getTypeName(this.currentPosition.getCurrentType()) + "'");
        }
        this.currentPosition.setAttribute(attribute);
        Type<?> type = this.getType(this.currentPosition.getCurrentType(), attribute);
        Type<?> valueType = null;
        Type keyType = null;
        if (attribute instanceof PluralAttribute) {
            Class javaType = type.getJavaType();
            Class[] typeArguments = javaType == null ? EMPTY : (attribute.getJavaMember() instanceof Field ? ReflectionUtils.getResolvedFieldTypeArguments(this.currentPosition.getCurrentClass(), (Field)((Field)attribute.getJavaMember())) : (attribute.getJavaMember() instanceof Method ? ReflectionUtils.getResolvedMethodReturnTypeArguments(this.currentPosition.getCurrentClass(), (Method)((Method)attribute.getJavaMember())) : EMPTY));
            valueType = this.metamodel.type(JpaMetamodelUtils.resolveFieldClass(this.currentPosition.getCurrentClass(), attribute));
            if (typeArguments.length == 0) {
                if (attribute instanceof MapAttribute) {
                    keyType = ((MapAttribute)attribute).getKeyType();
                }
            } else if (typeArguments.length > 1) {
                keyType = this.metamodel.type(typeArguments[0]);
            }
        }
        this.currentPosition.setCurrentType(type);
        this.currentPosition.setValueType(valueType);
        this.currentPosition.setKeyType(keyType);
    }

    @Override
    public void visit(GeneralCaseExpression expression) {
        List<PathPosition> currentPositions = this.pathPositions;
        ArrayList<PathPosition> newPositions = new ArrayList<PathPosition>();
        int positionsSize = currentPositions.size();
        for (int j = 0; j < positionsSize; ++j) {
            List<WhenClauseExpression> expressions = expression.getWhenClauses();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                PathPosition position = currentPositions.get(j).copy();
                this.pathPositions = new ArrayList<PathPosition>();
                this.currentPosition = position;
                this.pathPositions.add(this.currentPosition);
                expressions.get(i).accept(this);
                newPositions.addAll(this.pathPositions);
            }
            if (expression.getDefaultExpr() == null) continue;
            PathPosition position = currentPositions.get(j).copy();
            this.pathPositions = new ArrayList<PathPosition>();
            this.currentPosition = position;
            this.pathPositions.add(this.currentPosition);
            expression.getDefaultExpr().accept(this);
            newPositions.addAll(this.pathPositions);
        }
        this.currentPosition = null;
        this.pathPositions = newPositions;
    }

    @Override
    public void visit(PathExpression expression) {
        String property;
        List<PathElementExpression> expressions = expression.getExpressions();
        int size = expressions.size();
        int i = 0;
        PathElementExpression firstExpression = expressions.get(0);
        if (firstExpression instanceof PropertyExpression && this.rootTypes.containsKey(property = ((PropertyExpression)firstExpression).getProperty())) {
            i = 1;
            this.currentPosition.setCurrentType(this.rootTypes.get(property));
        }
        if (this.currentPosition.getCurrentType() == null) {
            if (expression.getPathReference() != null) {
                this.currentPosition.setCurrentType(expression.getPathReference().getType());
            }
            return;
        }
        while (i < size) {
            expressions.get(i).accept(this);
            ++i;
        }
    }

    @Override
    public void visit(ListIndexExpression expression) {
        expression.getPath().accept(this);
        Class<?> type = this.currentPosition.getRealCurrentClass();
        if (!List.class.isAssignableFrom(type)) {
            this.invalid(expression, "Does not resolve to java.util.List!");
        } else {
            this.currentPosition.setAttribute((Attribute<?, ?>)new ListIndexAttribute((ListAttribute)this.currentPosition.getAttribute()));
            this.currentPosition.setValueType(null);
            this.currentPosition.setKeyType(this.metamodel.type(Integer.class));
        }
    }

    @Override
    public void visit(MapEntryExpression expression) {
        expression.getPath().accept(this);
        this.currentPosition.setAttribute((Attribute<?, ?>)new MapEntryAttribute((MapAttribute)this.currentPosition.getAttribute()));
        this.currentPosition.setCurrentType(this.metamodel.type(Map.Entry.class));
    }

    @Override
    public void visit(MapKeyExpression expression) {
        expression.getPath().accept(this);
        this.currentPosition.setAttribute((Attribute<?, ?>)new MapKeyAttribute((MapAttribute)this.currentPosition.getAttribute()));
        this.currentPosition.setValueType(null);
    }

    @Override
    public void visit(MapValueExpression expression) {
        expression.getPath().accept(this);
        this.currentPosition.setKeyType(null);
    }

    @Override
    public void visit(ArrayExpression expression) {
        if (expression.getBase() instanceof EntityLiteral) {
            EntityType type = this.metamodel.getEntity(((EntityLiteral)expression.getBase()).getValue());
            this.currentPosition.setCurrentType((Type<?>)type);
        } else {
            expression.getBase().accept(this);
        }
    }

    @Override
    public void visit(TreatExpression expression) {
        PathExpression treatPath;
        boolean handled = false;
        if (expression.getExpression() instanceof PathExpression && (treatPath = (PathExpression)expression.getExpression()).getExpressions().size() == 1 && this.rootTypes.containsKey(treatPath.getExpressions().get(0).toString())) {
            handled = true;
        }
        if (!handled) {
            expression.getExpression().accept(this);
        }
        EntityType<?> type = this.metamodel.getEntity(expression.getType());
        this.currentPosition.setCurrentType((Type<?>)type);
        this.currentPosition.setValueType((Type<?>)type);
    }

    @Override
    public void visit(ParameterExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(NullExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(SubqueryExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(ArithmeticExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(NumericLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(BooleanLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(DateLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(TimeLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(TimestampLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(EnumLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(EntityLiteral expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(FunctionExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(TypeFunctionExpression expression) {
        this.invalid(expression);
    }

    @Override
    public void visit(TrimExpression expression) {
        expression.getTrimSource().accept(this);
    }

    @Override
    public void visit(SimpleCaseExpression expression) {
        this.visit((GeneralCaseExpression)expression);
    }

    @Override
    public void visit(WhenClauseExpression expression) {
        expression.getResult().accept(this);
    }

    @Override
    public void visit(CompoundPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(EqPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(IsNullPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(IsEmptyPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(MemberOfPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(LikePredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(BetweenPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(InPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(GtPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(GePredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(LtPredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(LePredicate predicate) {
        this.invalid(predicate);
    }

    @Override
    public void visit(ExistsPredicate predicate) {
        this.invalid(predicate);
    }

    protected final void invalid(Object o) {
        throw new IllegalArgumentException("Illegal occurence of [" + o + "] in path chain resolver!");
    }

    protected final void invalid(Object o, String reason) {
        throw new IllegalArgumentException("Illegal occurence of [" + o + "] in path chain resolver! " + reason);
    }

    protected static class PathPosition {
        public Type<?> currentClass;
        public Type<?> valueClass;
        public Type<?> keyClass;
        public Attribute<?, ?> attribute;

        public PathPosition(Type<?> currentClass, Attribute<?, ?> attribute) {
            this.currentClass = currentClass;
            this.attribute = attribute;
        }

        private PathPosition(Type<?> currentClass, Type<?> valueClass, Type<?> keyClass, Attribute<?, ?> attribute) {
            this.currentClass = currentClass;
            this.valueClass = valueClass;
            this.keyClass = keyClass;
            this.attribute = attribute;
        }

        public Type<?> getRealCurrentType() {
            return this.currentClass;
        }

        public Class<?> getRealCurrentClass() {
            return this.currentClass == null ? null : this.currentClass.getJavaType();
        }

        public Type<?> getCurrentType() {
            if (this.valueClass != null) {
                return this.valueClass;
            }
            if (this.keyClass != null) {
                return this.keyClass;
            }
            return this.currentClass;
        }

        public Class<?> getCurrentClass() {
            return this.getCurrentType() == null ? null : this.getCurrentType().getJavaType();
        }

        public Class<?> getKeyCurrentClass() {
            return this.keyClass == null ? null : this.keyClass.getJavaType();
        }

        public void setCurrentType(Type<?> currentClass) {
            this.currentClass = currentClass;
            this.valueClass = null;
            this.keyClass = null;
        }

        public Attribute<?, ?> getAttribute() {
            return this.attribute;
        }

        public void setAttribute(Attribute<?, ?> attribute) {
            this.attribute = attribute;
        }

        public boolean hasCollectionJoin() {
            return this.valueClass != null;
        }

        void setValueType(Type<?> valueClass) {
            this.valueClass = valueClass;
        }

        void setKeyType(Type<?> keyClass) {
            this.keyClass = keyClass;
        }

        public PathPosition copy() {
            return new PathPosition(this.currentClass, this.valueClass, this.keyClass, this.attribute);
        }
    }
}

