/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Time;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;

public class OffsetTimeTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<OffsetTime> {
    public static final TypeConverter<?> INSTANCE = new OffsetTimeTypeConverter();
    private static final long serialVersionUID = 1L;

    private OffsetTimeTypeConverter() {
        super("literal_offset_time");
    }

    @Override
    public OffsetTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return OffsetTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), 0, ZoneOffset.ofHours(0));
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return OffsetTime.of(calendar.get(11), calendar.get(12), calendar.get(13), 0, ZoneOffset.ofHours(0));
        }
        if (value instanceof String) {
            return Time.valueOf((String)value).toLocalTime().atOffset(ZoneOffset.ofHours(0));
        }
        throw OffsetTimeTypeConverter.unknownConversion(value, OffsetTime.class);
    }

    @Override
    public String toString(OffsetTime value) {
        return TypeUtils.jdbcTime(value.getHour(), value.getMinute(), value.getSecond());
    }

    @Override
    public void appendTo(OffsetTime value, StringBuilder stringBuilder) {
        TypeUtils.appendJdbcTime(stringBuilder, value.getHour(), value.getMinute(), value.getSecond());
    }
}

