/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.storage.core.api.AccountDataAccess;
import com.blazebit.storage.core.api.AccountService;
import com.blazebit.storage.core.api.BucketDataAccess;
import com.blazebit.storage.core.model.jpa.Account;
import com.blazebit.storage.rest.api.AccountSubResource;
import com.blazebit.storage.rest.api.AccountsResource;
import com.blazebit.storage.rest.api.StoragesSubResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.impl.StoragesSubResourceImpl;
import com.blazebit.storage.rest.impl.view.AccountRepresentationView;
import com.blazebit.storage.rest.impl.view.BucketListElementRepresentationView;
import com.blazebit.storage.rest.model.AccountRepresentation;
import com.blazebit.storage.rest.model.AccountUpdateRepresentation;
import com.blazebit.storage.rest.model.BucketListElementRepresentation;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class AccountSubResourceImpl
extends AbstractResource
implements AccountSubResource {
    private String key;
    @Inject
    private AccountService accountService;
    @Inject
    private AccountDataAccess accountDataAccess;
    @Inject
    private BucketDataAccess bucketDataAccess;

    public AccountSubResourceImpl(String key) {
        this.key = key;
    }

    public AccountRepresentation get() {
        AccountRepresentation result = (AccountRepresentation)this.accountDataAccess.findByKey(this.key, EntityViewSetting.create(AccountRepresentationView.class));
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Account not found").build());
        }
        return result;
    }

    public Response put(AccountUpdateRepresentation accountUpdate) {
        boolean isNew;
        Account account = this.getAccountByKey(this.key);
        boolean bl = isNew = account == null;
        if (isNew) {
            account = new Account();
            account.setKey(this.key);
        }
        account.setName(accountUpdate.getName());
        account.setTags(accountUpdate.getTags());
        if (isNew) {
            this.accountService.create(account);
        } else {
            this.accountService.update(account);
        }
        URI uri = this.uriInfo.getRequestUriBuilder().path(AccountsResource.class, "get").build(new Object[]{account.getId()});
        return Response.created((URI)uri).build();
    }

    public StoragesSubResource getStorages() {
        return this.inject(new StoragesSubResourceImpl(this.getAccountByKey(this.key)));
    }

    public List<BucketListElementRepresentation> getBuckets() {
        return this.bucketDataAccess.findByAccountId(this.getAccountByKey(this.key).getId().longValue(), EntityViewSetting.create(BucketListElementRepresentationView.class));
    }

    private Account getAccountByKey(String key) {
        return this.accountDataAccess.findByKey(key);
    }
}

