/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.storage.core.api.AccountDataAccess;
import com.blazebit.storage.core.api.BucketDataAccess;
import com.blazebit.storage.core.api.BucketObjectService;
import com.blazebit.storage.core.api.BucketService;
import com.blazebit.storage.core.model.jpa.Account;
import com.blazebit.storage.core.model.jpa.Bucket;
import com.blazebit.storage.core.model.jpa.BucketObjectId;
import com.blazebit.storage.core.model.jpa.Storage;
import com.blazebit.storage.core.model.jpa.StorageId;
import com.blazebit.storage.core.model.service.BucketObjectDeleteReport;
import com.blazebit.storage.core.model.service.BucketObjectDeleteReportItem;
import com.blazebit.storage.rest.api.BucketSubResource;
import com.blazebit.storage.rest.api.FileSubResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.impl.FileSubResourceImpl;
import com.blazebit.storage.rest.impl.view.BucketHeadRepresentationView;
import com.blazebit.storage.rest.impl.view.BucketRepresentationView;
import com.blazebit.storage.rest.model.BucketHeadRepresentation;
import com.blazebit.storage.rest.model.BucketObjectUpdateRepresentation;
import com.blazebit.storage.rest.model.BucketRepresentation;
import com.blazebit.storage.rest.model.BucketUpdateRepresentation;
import com.blazebit.storage.rest.model.ErrorRepresentation;
import com.blazebit.storage.rest.model.MultipartUploadRepresentation;
import com.blazebit.storage.rest.model.MultipartUploadResultRepresentation;
import com.blazebit.storage.rest.model.MultipleDeleteObjectRepresentation;
import com.blazebit.storage.rest.model.MultipleDeleteObjectResultRepresentation;
import com.blazebit.storage.rest.model.MultipleDeleteRepresentation;
import com.blazebit.storage.rest.model.MultipleDeleteResultRepresentation;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class BucketSubResourceImpl
extends AbstractResource
implements BucketSubResource {
    private static final Logger LOG = Logger.getLogger(BucketSubResourceImpl.class.getName());
    private final long accountId;
    private final String bucketId;
    @Inject
    private AccountDataAccess accountDataAccess;
    @Inject
    private BucketDataAccess bucketDataAccess;
    @Inject
    private BucketService bucketService;
    @Inject
    private BucketObjectService bucketObjectService;

    public BucketSubResourceImpl(long accountId, String bucketId) {
        this.accountId = accountId;
        this.bucketId = bucketId;
    }

    public BucketRepresentation get(String prefix, Integer limit, String marker) {
        EntityViewSetting setting = EntityViewSetting.create(BucketRepresentationView.class);
        BucketRepresentationView result = (BucketRepresentationView)((Object)this.bucketDataAccess.findByName(this.bucketId, prefix, limit, marker, setting));
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Bucket not found").build());
        }
        if (!result.getOwnerId().equals(this.accountId) && !this.userContext.getAccountRoles().contains("admin")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Not allowed to access bucket").build());
        }
        return result;
    }

    public BucketHeadRepresentation head() {
        EntityViewSetting setting = EntityViewSetting.create(BucketHeadRepresentationView.class);
        BucketHeadRepresentationView result = (BucketHeadRepresentationView)((Object)this.bucketDataAccess.findByName(this.bucketId, setting));
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        if (!result.getOwnerId().equals(this.accountId) && !this.userContext.getAccountRoles().contains("admin")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
        return result;
    }

    public Response delete() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).type("text/plain").entity((Object)"Not yet implemented").build());
    }

    public Response put(BucketUpdateRepresentation bucketUpdate, String ownerKey) {
        Account storageOwner;
        Bucket bucket = new Bucket(this.bucketId);
        if (ownerKey == null || ownerKey.isEmpty() || ownerKey.equals(this.userContext.getAccountKey())) {
            bucket.setOwner(new Account(Long.valueOf(this.accountId)));
        } else if (this.userContext.getAccountRoles().contains("admin")) {
            Account owner = this.accountDataAccess.findByKey(ownerKey);
            if (owner == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("x-blz-error-code", (Object)"AccountNotFound").type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Account does not exist").build());
            }
            bucket.setOwner(owner);
        } else {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Only admins may change the owner").build());
        }
        String storageOwnerKey = bucketUpdate.getDefaultStorageOwner();
        if (storageOwnerKey == null || storageOwnerKey.isEmpty() || storageOwnerKey.equals(this.userContext.getAccountKey())) {
            storageOwner = new Account(this.userContext.getAccountId());
        } else if (this.userContext.getAccountRoles().contains("admin")) {
            storageOwner = this.accountDataAccess.findByKey(storageOwnerKey);
            if (storageOwner == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).header("x-blz-error-code", (Object)"AccountNotFound").type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Account does not exist").build());
            }
        } else {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Only admins may change the storage owner").build());
        }
        bucket.setStorage(new Storage(new StorageId(storageOwner.getId(), bucketUpdate.getDefaultStorageName())));
        this.bucketService.put(bucket);
        return Response.ok().build();
    }

    public MultipartUploadResultRepresentation uploadMultiple(MultipartUploadRepresentation upload) {
        boolean verbose = !upload.isQuiet();
        ArrayList<String> uploaded = new ArrayList<String>(upload.getUploads().size());
        ArrayList<ErrorRepresentation> errors = new ArrayList<ErrorRepresentation>();
        MultipartUploadResultRepresentation result = new MultipartUploadResultRepresentation(uploaded, errors);
        ArrayList<Throwable> exceptions = null;
        try (MultipartUploadRepresentation u = upload;){
            for (Map.Entry entry : upload.getUploads().entrySet()) {
                Response r;
                String fileKey = (String)entry.getKey();
                try {
                    r = this.getFile(fileKey).put((BucketObjectUpdateRepresentation)entry.getValue());
                }
                catch (WebApplicationException ex) {
                    r = ex.getResponse();
                }
                catch (Throwable t) {
                    r = null;
                    if (exceptions == null) {
                        exceptions = new ArrayList<Throwable>();
                    }
                    exceptions.add(t);
                }
                if (r == null) continue;
                if (r.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    if (!verbose) continue;
                    uploaded.add(fileKey);
                    continue;
                }
                String code = r.getHeaderString("x-blz-error-code");
                String message = (String)r.readEntity(String.class);
                errors.add(new ErrorRepresentation(fileKey, code, message));
            }
            if (exceptions != null) {
                int size = exceptions.size();
                LOG.log(Level.SEVERE, size + " error(s) happened during multipart processing!");
                for (int i = 0; i < size; ++i) {
                    LOG.log(Level.SEVERE, " - Error " + i, (Throwable)exceptions.get(i));
                }
            }
        }
        return result;
    }

    public MultipleDeleteResultRepresentation deleteMultiple(MultipleDeleteRepresentation delete) {
        boolean verbose = !delete.isQuiet();
        ArrayList<MultipleDeleteObjectResultRepresentation> deleted = new ArrayList<MultipleDeleteObjectResultRepresentation>(delete.getObjects().size());
        ArrayList<ErrorRepresentation> errors = new ArrayList<ErrorRepresentation>();
        MultipleDeleteResultRepresentation result = new MultipleDeleteResultRepresentation(deleted, errors);
        ArrayList<BucketObjectId> bucketObjectIds = new ArrayList<BucketObjectId>(delete.getObjects().size());
        for (MultipleDeleteObjectRepresentation o : delete.getObjects()) {
            bucketObjectIds.add(new BucketObjectId(this.bucketId, o.getKey()));
        }
        BucketObjectDeleteReport report = this.bucketObjectService.delete(bucketObjectIds);
        for (BucketObjectDeleteReportItem item : report.getItems()) {
            if (item.getMessage() == null) {
                if (!verbose) continue;
                deleted.add(new MultipleDeleteObjectResultRepresentation(item.getBucketObjectId().getName()));
                continue;
            }
            String code = item.getCode();
            String message = item.getMessage();
            errors.add(new ErrorRepresentation(item.getBucketObjectId().getName(), code, message));
        }
        return result;
    }

    public FileSubResource getFile(String key) {
        return this.inject(new FileSubResourceImpl(this.accountId, this.bucketId, key));
    }
}

