/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.storage.core.api.AccountDataAccess;
import com.blazebit.storage.core.api.BucketObjectDataAccess;
import com.blazebit.storage.core.api.BucketObjectNotFoundException;
import com.blazebit.storage.core.api.BucketObjectService;
import com.blazebit.storage.core.api.HexUtils;
import com.blazebit.storage.core.api.StorageDataAccess;
import com.blazebit.storage.core.api.StorageException;
import com.blazebit.storage.core.api.spi.StorageResult;
import com.blazebit.storage.core.model.jpa.Account;
import com.blazebit.storage.core.model.jpa.Bucket;
import com.blazebit.storage.core.model.jpa.BucketObject;
import com.blazebit.storage.core.model.jpa.BucketObjectId;
import com.blazebit.storage.core.model.jpa.BucketObjectVersion;
import com.blazebit.storage.core.model.jpa.Storage;
import com.blazebit.storage.core.model.jpa.StorageId;
import com.blazebit.storage.rest.api.FileSubResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.impl.view.BucketObjectRepresentationView;
import com.blazebit.storage.rest.impl.view.BucketObjectVersionRepresentationView;
import com.blazebit.storage.rest.model.BucketObjectHeadRepresentation;
import com.blazebit.storage.rest.model.BucketObjectRepresentation;
import com.blazebit.storage.rest.model.BucketObjectUpdateRepresentation;
import com.blazebit.storage.rest.model.rs.ContentDisposition;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

public class FileSubResourceImpl
extends AbstractResource
implements FileSubResource {
    private final long accountId;
    private final BucketObjectId bucketObjectId;
    @Context
    private HttpServletRequest request;
    @Inject
    private BucketObjectDataAccess bucketObjectDataAccess;
    @Inject
    private BucketObjectService bucketObjectService;
    @Inject
    private StorageDataAccess storageDataAccess;
    @Inject
    private AccountDataAccess accountDataAccess;

    public FileSubResourceImpl(long accountId, String bucketId, String key) {
        this.accountId = accountId;
        this.bucketObjectId = new BucketObjectId(new Bucket(bucketId), key);
    }

    public BucketObjectRepresentation get() {
        return (BucketObjectRepresentation)this.getOrHead(true);
    }

    public BucketObjectHeadRepresentation head() {
        return this.getOrHead(false);
    }

    private BucketObjectHeadRepresentation getOrHead(boolean isGet) {
        BucketObjectRepresentationView result = this.getBucketObject(this.bucketObjectId);
        BucketObjectVersionRepresentationView version = result.getContentVersion();
        Object response = isGet ? new BucketObjectRepresentation() : new BucketObjectHeadRepresentation();
        response.setContentType(version.getContentType());
        response.setContentDisposition(ContentDisposition.fromString((String)version.getContentDisposition()));
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTime(new Date(version.getLastModified()));
        response.setLastModified(lastModified);
        response.setEntityTag(version.getEntityTag());
        response.setSize(version.getContentLength().longValue());
        response.setStorageName(version.getStorageName());
        response.setStorageOwner(version.getStorageOwnerKey());
        response.setTags(version.getTags());
        if (isGet) {
            InputStream is = this.bucketObjectDataAccess.getContent(version.getStorageUri(), version.getContentKey());
            response.setContent(is);
        }
        return response;
    }

    private BucketObjectRepresentationView getBucketObject(BucketObjectId objectId) {
        EntityViewSetting setting = EntityViewSetting.create(BucketObjectRepresentationView.class);
        BucketObjectRepresentationView result = (BucketObjectRepresentationView)this.bucketObjectDataAccess.findById(objectId, setting);
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Bucket object not found").build());
        }
        if (!result.getOwnerId().equals(this.accountId) && !this.userContext.getAccountRoles().contains("admin")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Not allowed to access bucket object").build());
        }
        return result;
    }

    public Response delete() {
        try {
            this.bucketObjectService.delete(this.bucketObjectId);
            return Response.noContent().build();
        }
        catch (BucketObjectNotFoundException ex) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Bucket object not found").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(BucketObjectUpdateRepresentation bucketObjectUpdate) {
        long contentLength;
        String contentMd5;
        String contentKey;
        byte[] md5Bytes = bucketObjectUpdate.getContentMD5() == null ? null : HexUtils.hexStringToByteArray((String)bucketObjectUpdate.getContentMD5());
        Storage storage = this.getStorage(this.accountId, this.bucketObjectId.getBucketId(), bucketObjectUpdate.getStorageOwner(), bucketObjectUpdate.getStorageName());
        URI storageUri = storage.getUri();
        String externalContentKey = bucketObjectUpdate.getExternalContentKey();
        if (externalContentKey != null && !externalContentKey.isEmpty()) {
            if (bucketObjectUpdate.getCopySource() != null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Copy source not allowed with external content key!").build();
            }
            contentKey = externalContentKey;
            contentMd5 = bucketObjectUpdate.getContentMD5();
            contentLength = bucketObjectUpdate.getSize();
        } else if (bucketObjectUpdate.getCopySource() != null) {
            int idx;
            String source = bucketObjectUpdate.getCopySource();
            if (source.charAt(0) != '/' || (idx = source.indexOf(47, 1)) < 2) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Invalid copy source format. Expected '/bucketName/key'").build();
            }
            String sourceBucket = source.substring(1, idx);
            String sourceKey = source.substring(idx + 1);
            BucketObjectRepresentationView result = this.getBucketObject(new BucketObjectId(sourceBucket, sourceKey));
            BucketObjectVersionRepresentationView contentVersion = result.getContentVersion();
            URI sourceStorageUri = contentVersion.getStorageUri();
            String sourceContentKey = contentVersion.getContentKey();
            StorageResult storageResult = this.bucketObjectService.copyContent(sourceStorageUri, sourceContentKey, storageUri);
            contentKey = storageResult.getExternalKey();
            contentMd5 = HexUtils.bytesToHex((byte[])storageResult.getMd5Checksum());
            if (md5Bytes != null && storageResult.getMd5Checksum() != null && !Arrays.equals(md5Bytes, storageResult.getMd5Checksum())) {
                this.bucketObjectService.deleteContent(storageUri, storageResult.getExternalKey());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The expected MD5 checksum " + bucketObjectUpdate.getContentMD5() + " did not match the actual MD5 checksum " + contentMd5)).build();
            }
            contentLength = contentVersion.getContentLength();
            if (bucketObjectUpdate.getContentDisposition() == null) {
                bucketObjectUpdate.setContentDisposition(ContentDisposition.fromString((String)contentVersion.getContentDisposition()));
            }
            if (bucketObjectUpdate.getTags() == null || bucketObjectUpdate.getTags().isEmpty()) {
                bucketObjectUpdate.setTags(contentVersion.getTags());
            }
            bucketObjectUpdate.setContentType(contentVersion.getContentType());
        } else {
            InputStream inputStream;
            try {
                inputStream = bucketObjectUpdate.getContent().getInputStream();
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            StorageResult storageResult = this.bucketObjectService.createContent(storageUri, inputStream);
            contentKey = storageResult.getExternalKey();
            contentMd5 = HexUtils.bytesToHex((byte[])storageResult.getMd5Checksum());
            if (md5Bytes != null && storageResult.getMd5Checksum() != null && !Arrays.equals(md5Bytes, storageResult.getMd5Checksum())) {
                this.bucketObjectService.deleteContent(storageUri, storageResult.getExternalKey());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The expected MD5 checksum " + bucketObjectUpdate.getContentMD5() + " did not match the actual MD5 checksum " + contentMd5)).build();
            }
            long expectedContentLength = bucketObjectUpdate.getSize();
            if (expectedContentLength >= 0L && expectedContentLength != storageResult.getSize()) {
                this.bucketObjectService.deleteContent(storageUri, storageResult.getExternalKey());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The expected content length " + expectedContentLength + " did not match the actual content length " + storageResult.getSize())).build();
            }
            contentLength = storageResult.getSize();
        }
        BucketObject bucketObject = new BucketObject(this.bucketObjectId);
        BucketObjectVersion version = new BucketObjectVersion();
        bucketObject.setContentVersion(version);
        if (bucketObjectUpdate.getContentDisposition() != null) {
            version.setContentDisposition(bucketObjectUpdate.getContentDisposition().toString());
        }
        version.setContentLength(contentLength);
        version.setContentMD5(contentMd5);
        version.setContentType(bucketObjectUpdate.getContentType());
        version.setContentKey(contentKey);
        version.setEntityTag("");
        version.setStorage(storage);
        version.setTags(bucketObjectUpdate.getTags());
        boolean success = false;
        try {
            this.bucketObjectService.put(bucketObject);
            success = true;
        }
        finally {
            if (!success && !contentKey.equals(externalContentKey)) {
                this.bucketObjectService.deleteContent(storageUri, contentKey);
            }
        }
        return Response.ok().build();
    }

    private Storage getStorage(long accountId, String bucketId, String storageOwner, String storageName) {
        Storage storage;
        if (storageOwner != null && !storageOwner.isEmpty() && this.userContext.getAccountRoles().contains("admin") && !this.userContext.getAccountKey().equals(storageOwner)) {
            Account storageOwnerAccount = this.accountDataAccess.findByKey(storageOwner);
            if (storageOwnerAccount == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("x-blz-error-code", (Object)"StorageOwnerNotFound").type("text/plain").entity((Object)("Storage owner '" + storageOwner + "' not found")).build());
            }
            accountId = storageOwnerAccount.getId();
        }
        if ((storage = storageName != null && !storageName.isEmpty() ? this.storageDataAccess.findById(new StorageId(Long.valueOf(accountId), storageName)) : this.storageDataAccess.findByBucketId(bucketId)) == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).header("x-blz-error-code", (Object)"StorageNotFound").type("text/plain").entity((Object)"Storage not found").build());
        }
        if (!storage.getId().getOwnerId().equals(accountId) && !this.userContext.getAccountRoles().contains("admin")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"No allowed to access storage").build());
        }
        return storage;
    }
}

