/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.storage.core.api.StorageQuotaModelDataAccess;
import com.blazebit.storage.core.api.StorageQuotaModelService;
import com.blazebit.storage.core.model.jpa.StorageQuotaModel;
import com.blazebit.storage.core.model.jpa.StorageQuotaPlan;
import com.blazebit.storage.rest.api.StorageQuotaModelSubResource;
import com.blazebit.storage.rest.api.StorageQuotaModelsResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.impl.view.StorageQuotaModelRepresentationView;
import com.blazebit.storage.rest.model.StorageQuotaModelRepresentation;
import com.blazebit.storage.rest.model.StorageQuotaModelUpdateRepresentation;
import java.net.URI;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class StorageQuotaModelSubResourceImpl
extends AbstractResource
implements StorageQuotaModelSubResource {
    private String id;
    @Inject
    private StorageQuotaModelService storageQuotaModelService;
    @Inject
    private StorageQuotaModelDataAccess storageQuotaModelDataAccess;

    public StorageQuotaModelSubResourceImpl(String id) {
        this.id = id;
    }

    public StorageQuotaModelRepresentation get() {
        StorageQuotaModelRepresentation result = (StorageQuotaModelRepresentation)this.storageQuotaModelDataAccess.findById(this.id, EntityViewSetting.create(StorageQuotaModelRepresentationView.class));
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Storage quota model not found").build());
        }
        return result;
    }

    public Response put(StorageQuotaModelUpdateRepresentation quotaModelUpdate) {
        boolean isNew;
        StorageQuotaModel storageQuotaModel = this.getById(this.id);
        boolean bl = isNew = storageQuotaModel == null;
        if (isNew) {
            storageQuotaModel = new StorageQuotaModel(this.id);
        }
        storageQuotaModel.setName(quotaModelUpdate.getName());
        storageQuotaModel.setDescription(quotaModelUpdate.getDescription());
        storageQuotaModel.setPlans(this.getPlans(storageQuotaModel, quotaModelUpdate.getLimits()));
        if (isNew) {
            this.storageQuotaModelService.create(storageQuotaModel);
        } else {
            this.storageQuotaModelService.update(storageQuotaModel);
        }
        URI uri = this.uriInfo.getRequestUriBuilder().path(StorageQuotaModelsResource.class, "get").build(new Object[]{storageQuotaModel.getId()});
        return Response.created((URI)uri).build();
    }

    private SortedSet<StorageQuotaPlan> getPlans(StorageQuotaModel storageQuotaModel, Set<Integer> limits) {
        TreeSet<StorageQuotaPlan> plans = new TreeSet<StorageQuotaPlan>();
        for (Integer limit : limits) {
            StorageQuotaPlan plan = new StorageQuotaPlan();
            plan.getId().setQuotaModelId(storageQuotaModel.getId());
            plan.getId().setGigabyteLimit(limit);
            plan.setQuotaModel(storageQuotaModel);
            plan.setAlertPercent(Short.valueOf((short)100));
            plans.add(plan);
        }
        return plans;
    }

    private StorageQuotaModel getById(String id) {
        return this.storageQuotaModelDataAccess.findById(id);
    }
}

