/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.storage.core.api.StorageDataAccess;
import com.blazebit.storage.core.api.StorageProviderFactoryDataAccess;
import com.blazebit.storage.core.api.StorageService;
import com.blazebit.storage.core.model.jpa.Account;
import com.blazebit.storage.core.model.jpa.Storage;
import com.blazebit.storage.core.model.jpa.StorageId;
import com.blazebit.storage.core.model.jpa.StorageQuotaPlan;
import com.blazebit.storage.core.model.jpa.StorageQuotaPlanId;
import com.blazebit.storage.rest.api.AccountSubResource;
import com.blazebit.storage.rest.api.AccountsResource;
import com.blazebit.storage.rest.api.StorageSubResource;
import com.blazebit.storage.rest.api.StoragesSubResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.impl.view.StorageRepresentationView;
import com.blazebit.storage.rest.model.StorageRepresentation;
import com.blazebit.storage.rest.model.StorageUpdateRepresentation;
import com.blazebit.storage.rest.model.config.StorageTypeConfigEntryRepresentation;
import java.net.URI;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class StorageSubResourceImpl
extends AbstractResource
implements StorageSubResource {
    private StorageId id;
    @Inject
    private StorageDataAccess storageDataAccess;
    @Inject
    private StorageService storageService;
    @Inject
    private StorageProviderFactoryDataAccess storageProviderFactoryDataAccess;

    public StorageSubResourceImpl(Account owner, String storageName) {
        this.id = new StorageId(owner.getId(), storageName);
    }

    public StorageRepresentation get() {
        StorageRepresentation result = (StorageRepresentation)this.storageDataAccess.findById(this.id, EntityViewSetting.create(StorageRepresentationView.class));
        if (result == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Storage not found").build());
        }
        return result;
    }

    public Response put(StorageUpdateRepresentation<StorageTypeConfigEntryRepresentation> storageUpdate) {
        Storage storage = new Storage(this.id);
        storage.setQuotaPlan(new StorageQuotaPlan(new StorageQuotaPlanId(storageUpdate.getQuotaPlan().getModelId(), storageUpdate.getQuotaPlan().getGigabyteLimit())));
        storage.setTags(storageUpdate.getTags());
        LinkedHashMap<String, String> configurationMap = new LinkedHashMap<String, String>(storageUpdate.getConfiguration().size());
        for (StorageTypeConfigEntryRepresentation entry : storageUpdate.getConfiguration()) {
            configurationMap.put(entry.getKey(), entry.getValue());
        }
        storage.setUri(this.storageProviderFactoryDataAccess.getConfigurationUri(storageUpdate.getType(), configurationMap));
        this.storageService.put(storage);
        URI uri = this.uriInfo.getRequestUriBuilder().path(AccountsResource.class, "get").path(AccountSubResource.class, "getStorages").path(StoragesSubResource.class, "get").build(new Object[]{storage.getId().getOwnerId(), storage.getId().getName()});
        return Response.created((URI)uri).build();
    }
}

