/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl;

import com.blazebit.storage.core.api.StorageProviderFactoryDataAccess;
import com.blazebit.storage.core.api.spi.StorageProviderConfigurationElement;
import com.blazebit.storage.core.api.spi.StorageProviderFactory;
import com.blazebit.storage.core.api.spi.StorageProviderMetamodel;
import com.blazebit.storage.rest.api.StorageTypesResource;
import com.blazebit.storage.rest.impl.AbstractResource;
import com.blazebit.storage.rest.model.StorageTypeListElementRepresentation;
import com.blazebit.storage.rest.model.StorageTypeRepresentation;
import com.blazebit.storage.rest.model.config.StorageTypeConfigElementRepresentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class StorageTypesResourceImpl
extends AbstractResource
implements StorageTypesResource {
    private final List<StorageProviderMetamodel> metamodelList = new ArrayList<StorageProviderMetamodel>();
    private final Map<String, StorageProviderMetamodel> metamodelMap = new HashMap<String, StorageProviderMetamodel>();
    @Inject
    private StorageProviderFactoryDataAccess storageProviderFactoryDataAccess;

    @PostConstruct
    public void init() {
        for (StorageProviderFactory factory : this.storageProviderFactoryDataAccess.findAll()) {
            StorageProviderMetamodel metamodel = factory.getMetamodel();
            this.metamodelList.add(metamodel);
            this.metamodelMap.put(metamodel.getScheme(), metamodel);
        }
    }

    public List<StorageTypeListElementRepresentation> get() {
        ArrayList<StorageTypeListElementRepresentation> list = new ArrayList<StorageTypeListElementRepresentation>(this.metamodelList.size());
        for (StorageProviderMetamodel metamodel : this.metamodelList) {
            StorageTypeListElementRepresentation element = new StorageTypeListElementRepresentation();
            element.setKey(metamodel.getScheme());
            element.setName(metamodel.getName());
            element.setDescription(metamodel.getDescription());
            list.add(element);
        }
        return list;
    }

    public StorageTypeRepresentation get(String type) {
        StorageProviderMetamodel metamodel = this.metamodelMap.get(type);
        if (metamodel == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Could not find storage type!").build());
        }
        StorageTypeRepresentation element = new StorageTypeRepresentation();
        element.setKey(metamodel.getScheme());
        element.setName(metamodel.getName());
        element.setDescription(metamodel.getDescription());
        Set configElements = metamodel.getConfigurationElements();
        ArrayList<StorageTypeConfigElementRepresentation> storageTypeConfigs = new ArrayList<StorageTypeConfigElementRepresentation>(configElements.size());
        for (StorageProviderConfigurationElement config : configElements) {
            StorageTypeConfigElementRepresentation storageTypeConfig = new StorageTypeConfigElementRepresentation();
            storageTypeConfig.setKey(config.getKey());
            storageTypeConfig.setType(config.getType());
            storageTypeConfig.setValue(config.getDefaultValue());
            storageTypeConfig.setName(config.getName());
            storageTypeConfig.setDescription(config.getDescription());
            storageTypeConfigs.add(storageTypeConfig);
        }
        element.setConfiguration(storageTypeConfigs);
        return element;
    }
}

