/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl.view;

import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.storage.core.model.jpa.Bucket;
import com.blazebit.storage.core.model.jpa.ObjectStatistics;
import com.blazebit.storage.core.model.jpa.StorageId;
import com.blazebit.storage.rest.impl.view.BucketObjectListElementRepresentationView;
import com.blazebit.storage.rest.model.BucketRepresentation;
import com.blazebit.storage.rest.model.StatisticsRepresentation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Calendar;
import java.util.List;

@EntityView(value=Bucket.class)
public abstract class BucketRepresentationView
extends BucketRepresentation {
    private static final long serialVersionUID = 1L;

    public BucketRepresentationView(@Mapping(value="id") String id, @Mapping(value="owner.key") String ownerKey, @Mapping(value="storage.owner.key") String storageOwner, @Mapping(value="storage.id") StorageId storageId, @Mapping(value="creationDate") Calendar creationDate, @Mapping(value="statistics") ObjectStatistics statistics, @Mapping(value="objects") @CollectionMapping(ignoreIndex=true) List<BucketObjectListElementRepresentationView> objects) {
        super(storageOwner, storageId.getName(), id, ownerKey, creationDate, objects.size() > 1000 ? objects.remove(objects.size() - 1).getKey() : null, BucketRepresentationView.toStatistics(statistics), objects);
    }

    @JsonIgnore
    @IdMapping(value="id")
    public abstract String getId();

    @JsonIgnore
    @Mapping(value="owner.id")
    public abstract Long getOwnerId();

    private static StatisticsRepresentation toStatistics(ObjectStatistics statistics) {
        StatisticsRepresentation result = new StatisticsRepresentation();
        result.setObjectBytes(statistics.getObjectBytes());
        result.setObjectCount(statistics.getObjectCount());
        result.setObjectVersionBytes(statistics.getObjectVersionBytes());
        result.setObjectVersionCount(statistics.getObjectVersionCount());
        return result;
    }
}

