/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.storage.rest.impl.view;

import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.storage.core.api.StorageProviderFactoryDataAccess;
import com.blazebit.storage.core.api.spi.StorageProviderConfigurationElement;
import com.blazebit.storage.core.api.spi.StorageProviderFactory;
import com.blazebit.storage.core.api.spi.StorageProviderMetamodel;
import com.blazebit.storage.core.model.jpa.ObjectStatistics;
import com.blazebit.storage.core.model.jpa.Storage;
import com.blazebit.storage.core.model.jpa.StorageId;
import com.blazebit.storage.rest.impl.view.StorageQuotaPlanChoiceRepresentationView;
import com.blazebit.storage.rest.model.StatisticsRepresentation;
import com.blazebit.storage.rest.model.StorageQuotaPlanChoiceRepresentation;
import com.blazebit.storage.rest.model.StorageRepresentation;
import com.blazebit.storage.rest.model.config.StorageTypeConfigElementRepresentation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@EntityView(value=Storage.class)
public abstract class StorageRepresentationView
extends StorageRepresentation {
    private static final long serialVersionUID = 1L;

    public StorageRepresentationView(@Mapping(value="id.name") String name, @Mapping(value="uri") URI uri, @Mapping(value="creationDate") Calendar creationDate, @Mapping(value="quotaPlan") StorageQuotaPlanChoiceRepresentationView quotaPlan, @Mapping(value="tags") Map<String, String> tags, @Mapping(value="statistics") ObjectStatistics statistics, @MappingParameter(value="storageProviderFactoryDataAccess") StorageProviderFactoryDataAccess storageProviderFactoryDataAccess) {
        super(storageProviderFactoryDataAccess.getType(uri), (StorageQuotaPlanChoiceRepresentation)quotaPlan, StorageRepresentationView.toConfiguration(storageProviderFactoryDataAccess, uri), tags, name, creationDate, StorageRepresentationView.toStatistics(statistics));
    }

    @JsonIgnore
    @IdMapping(value="id")
    public abstract StorageId getId();

    private static StatisticsRepresentation toStatistics(ObjectStatistics statistics) {
        StatisticsRepresentation result = new StatisticsRepresentation();
        result.setObjectBytes(statistics.getObjectBytes());
        result.setObjectCount(statistics.getObjectCount());
        result.setObjectVersionBytes(statistics.getObjectVersionBytes());
        result.setObjectVersionCount(statistics.getObjectVersionCount());
        return result;
    }

    private static Set<StorageTypeConfigElementRepresentation> toConfiguration(StorageProviderFactoryDataAccess storageProviderFactoryDataAccess, URI uri) {
        Map configMap = storageProviderFactoryDataAccess.getConfiguration(uri);
        StorageProviderFactory factory = storageProviderFactoryDataAccess.findByScheme(storageProviderFactoryDataAccess.getType(uri));
        StorageProviderMetamodel metamodel = factory.getMetamodel();
        LinkedHashSet<StorageTypeConfigElementRepresentation> result = new LinkedHashSet<StorageTypeConfigElementRepresentation>(configMap.size());
        for (Map.Entry entry : configMap.entrySet()) {
            StorageProviderConfigurationElement configElement = metamodel.getConfigurationElement((String)entry.getKey());
            StorageTypeConfigElementRepresentation resultConfig = new StorageTypeConfigElementRepresentation();
            resultConfig.setKey((String)entry.getKey());
            resultConfig.setType(configElement.getType());
            resultConfig.setValue((String)entry.getValue());
            resultConfig.setName(configElement.getName());
            resultConfig.setDescription(configElement.getDescription());
            result.add(resultConfig);
        }
        return result;
    }
}

