/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.weblink.rest.client;

import com.blazebit.weblink.rest.api.AccountsResource;
import com.blazebit.weblink.rest.api.AdminResource;
import com.blazebit.weblink.rest.api.DispatcherTypesResource;
import com.blazebit.weblink.rest.api.KeyStrategiesResource;
import com.blazebit.weblink.rest.api.MatcherTypesResource;
import com.blazebit.weblink.rest.api.SecurityConstraintTypesResource;
import com.blazebit.weblink.rest.api.WeblinkGroupSubResource;
import com.blazebit.weblink.rest.api.WeblinkGroupsResource;
import com.blazebit.weblink.rest.api.WeblinkGroupsSubResource;
import com.blazebit.weblink.rest.api.WeblinkSubResource;
import com.blazebit.weblink.rest.client.BlazeWeblink;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

public class BlazeWeblinkClient
implements BlazeWeblink,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String serverUrl;
    private final ClientRequestFilter[] requestFilters;
    private final transient Client client;

    private BlazeWeblinkClient(String serverUrl, ClientRequestFilter[] requestFilters) {
        this.serverUrl = serverUrl;
        this.requestFilters = requestFilters;
        this.client = ClientBuilder.newClient();
    }

    private WebTarget initTarget() {
        WebTarget clientTarget = this.client.target(this.serverUrl);
        for (ClientRequestFilter filter : this.requestFilters) {
            clientTarget = (WebTarget)clientTarget.register((Object)filter);
        }
        return clientTarget;
    }

    public static BlazeWeblink getInstance(String serverUrl) {
        return new BlazeWeblinkClient(serverUrl, new ClientRequestFilter[0]);
    }

    public static BlazeWeblink getInstance(String serverUrl, ClientRequestFilter ... requestFilters) {
        return new BlazeWeblinkClient(serverUrl, requestFilters);
    }

    @Override
    public String getExternalLink(String weblinkGroupName, String weblinkKey) {
        return UriBuilder.fromUri((String)this.serverUrl).path(WeblinkGroupsResource.class).path(WeblinkGroupsResource.class, "get").path(WeblinkGroupsSubResource.class, "getGroup").path(WeblinkGroupSubResource.class, "getWeblink").path(WeblinkSubResource.class, "dispatch").build(new Object[]{weblinkGroupName, weblinkKey}).toString();
    }

    @Override
    public AdminResource admin() {
        return (AdminResource)WebResourceFactory.newResource(AdminResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public AccountsResource accounts() {
        return (AccountsResource)WebResourceFactory.newResource(AccountsResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public WeblinkGroupsSubResource weblinkGroups() {
        return ((WeblinkGroupsResource)WebResourceFactory.newResource(WeblinkGroupsResource.class, (WebTarget)this.initTarget())).get();
    }

    @Override
    public MatcherTypesResource matcherTypes() {
        return (MatcherTypesResource)WebResourceFactory.newResource(MatcherTypesResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public DispatcherTypesResource dispatcherTypes() {
        return (DispatcherTypesResource)WebResourceFactory.newResource(DispatcherTypesResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public KeyStrategiesResource keyStrategies() {
        return (KeyStrategiesResource)WebResourceFactory.newResource(KeyStrategiesResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public SecurityConstraintTypesResource securityConstraintTypes() {
        return (SecurityConstraintTypesResource)WebResourceFactory.newResource(SecurityConstraintTypesResource.class, (WebTarget)this.initTarget());
    }

    @Override
    public void close() {
        this.client.close();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.set("client", ClientBuilder.newClient());
    }

    private void set(String fieldName, Object value) {
        try {
            Field field = BlazeWeblinkClient.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

