/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.server.recovery;

import com.cloudera.livy.LivyConf;
import com.cloudera.livy.LivyConf$;
import com.cloudera.livy.Logging;
import com.cloudera.livy.server.recovery.StateStore;
import com.cloudera.livy.server.recovery.ZooKeeperStateStore$;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ev!B\u0001\u0003\u0011\u0003i\u0011a\u0005.p_.+W\r]3s'R\fG/Z*u_J,'BA\u0002\u0005\u0003!\u0011XmY8wKJL(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u0005A1\r\\8vI\u0016\u0014\u0018MC\u0001\f\u0003\r\u0019w.\\\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005MQvn\\&fKB,'o\u0015;bi\u0016\u001cFo\u001c:f'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bC\u0002\u0013\u0005Q$\u0001\n[\u0017~[U)W0Q%\u00163\u0015\nW0D\u001f:3U#\u0001\u0010\u0011\u0005}YcB\u0001\u0011*\u001d\t\t\u0003F\u0004\u0002#O9\u00111EJ\u0007\u0002I)\u0011Q\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001\u0016\u0007\u0003!a\u0015N^=D_:4\u0017B\u0001\u0017.\u0005\u0015)e\u000e\u001e:z\u0015\tQc\u0001\u0003\u00040\u001f\u0001\u0006IAH\u0001\u00145.{6*R-`!J+e)\u0013-`\u0007>se\t\t\u0005\bc=\u0011\r\u0011\"\u0001\u001e\u00035Q6j\u0018*F)JKvlQ(O\r\"11g\u0004Q\u0001\ny\taBW&`%\u0016#&+W0D\u001f:3\u0005\u0005C\u00046\u001fE\u0005I\u0011\u0001\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u00059$F\u0001\u001dH!\r\u0019\u0012hO\u0005\u0003uQ\u0011aa\u00149uS>t\u0007C\u0001\u001fF\u001b\u0005i$B\u0001 @\u0003%1'/Y7fo>\u00148N\u0003\u0002A\u0003\u000691-\u001e:bi>\u0014(B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!AR\u001f\u0003!\r+(/\u0019;pe\u001a\u0013\u0018-\\3x_J\\7&\u0001%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!C;oG\",7m[3e\u0015\tiE#\u0001\u0006b]:|G/\u0019;j_:L!a\u0014&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWM\u0002\u0003\u0011\u0005\u0001\t6c\u0001)S+B\u0011abU\u0005\u0003)\n\u0011!b\u0015;bi\u0016\u001cFo\u001c:f!\t1v+D\u0001\u0007\u0013\tAfAA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0003&\u0011!Q\u0001\nm\u000b\u0001\u0002\\5ws\u000e{gN\u001a\t\u0003-rK!!\u0018\u0004\u0003\u00111Kg/_\"p]\u001aD\u0001b\u0018)\u0003\u0002\u0003\u0006I\u0001O\u0001\u0012[>\u001c7nQ;sCR|'o\u00117jK:$\b\"B\rQ\t\u0003\tGc\u00012dIB\u0011a\u0002\u0015\u0005\u00065\u0002\u0004\ra\u0017\u0005\b?\u0002\u0004\n\u00111\u00019\u0011\u0015I\u0002\u000b\"\u0001g)\t\u0011w\rC\u0003[K\u0002\u00071\fC\u0004j!\n\u0007I\u0011\u00026\u0002\u0013i\\\u0017\t\u001a3sKN\u001cX#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001eDa\u0001\u001e)!\u0002\u0013Y\u0017A\u0003>l\u0003\u0012$'/Z:tA!9a\u000f\u0015b\u0001\n\u0013Q\u0017a\u0003>l\u0017\u0016L\bK]3gSbDa\u0001\u001f)!\u0002\u0013Y\u0017\u0001\u0004>l\u0017\u0016L\bK]3gSb\u0004\u0003b\u0002>Q\u0005\u0004%IA[\u0001\u000be\u0016$(/\u001f,bYV,\u0007B\u0002?QA\u0003%1.A\u0006sKR\u0014\u0018PV1mk\u0016\u0004\u0003b\u0002@Q\u0005\u0004%Ia`\u0001\re\u0016$(/\u001f)biR,'O\\\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\tY\u0001F\u0001\u0005kRLG.\u0003\u0003\u0002\u0010\u0005\u0015!!\u0002*fO\u0016D\b\u0002CA\n!\u0002\u0006I!!\u0001\u0002\u001bI,GO]=QCR$XM\u001d8!\u0011)\t9\u0002\u0015b\u0001\n\u0003\u0011\u0011\u0011D\u0001\fe\u0016$(/\u001f)pY&\u001c\u00170\u0006\u0002\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"}\nQA]3uefLA!!\n\u0002 \tY!+\u001a;ss:#\u0016.\\3t\u0011!\tI\u0003\u0015Q\u0001\n\u0005m\u0011\u0001\u0004:fiJL\bk\u001c7jGf\u0004\u0003\"CA\u0017!\n\u0007I\u0011BA\u0018\u00035\u0019WO]1u_J\u001cE.[3oiV\t1\bC\u0004\u00024A\u0003\u000b\u0011B\u001e\u0002\u001d\r,(/\u0019;pe\u000ec\u0017.\u001a8uA!9\u0011q\u0007)\u0005B\u0005e\u0012aA:fiR1\u00111HA!\u0003#\u00022aEA\u001f\u0013\r\ty\u0004\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002D\u0005U\u0002\u0019AA#\u0003\rYW-\u001f\t\u0005\u0003\u000f\niED\u0002\u0014\u0003\u0013J1!a\u0013\u0015\u0003\u0019\u0001&/\u001a3fM&\u0019!/a\u0014\u000b\u0007\u0005-C\u0003\u0003\u0005\u0002T\u0005U\u0002\u0019AA+\u0003\u00151\u0018\r\\;f!\ra\u0017qK\u0005\u0004\u00033j'AB(cU\u0016\u001cG\u000fC\u0004\u0002^A#\t%a\u0018\u0002\u0007\u001d,G/\u0006\u0003\u0002b\u0005-D\u0003BA2\u0003\u001b#B!!\u001a\u0002~A!1#OA4!\u0011\tI'a\u001b\r\u0001\u0011A\u0011QNA.\u0005\u0004\tyGA\u0001U#\u0011\t\t(a\u001e\u0011\u0007M\t\u0019(C\u0002\u0002vQ\u0011qAT8uQ&tw\rE\u0002\u0014\u0003sJ1!a\u001f\u0015\u0005\r\te.\u001f\u0005\u000b\u0003\u007f\nY&!AA\u0004\u0005\u0005\u0015AC3wS\u0012,gnY3%cA1\u00111QAE\u0003Oj!!!\"\u000b\u0007\u0005\u001dE#A\u0004sK\u001adWm\u0019;\n\t\u0005-\u0015Q\u0011\u0002\t\u00072\f7o\u001d+bO\"A\u00111IA.\u0001\u0004\t)\u0005C\u0004\u0002\u0012B#\t%a%\u0002\u0017\u001d,Go\u00115jY\u0012\u0014XM\u001c\u000b\u0005\u0003+\u000b9\u000b\u0005\u0004\u0002\u0018\u0006\u0005\u0016Q\t\b\u0005\u00033\u000biJD\u0002$\u00037K\u0011!F\u0005\u0004\u0003?#\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003G\u000b)KA\u0002TKFT1!a(\u0015\u0011!\t\u0019%a$A\u0002\u0005\u0015\u0003bBAV!\u0012\u0005\u0013QV\u0001\u0007e\u0016lwN^3\u0015\t\u0005m\u0012q\u0016\u0005\t\u0003\u0007\nI\u000b1\u0001\u0002F!9\u00111\u0017)\u0005\n\u0005U\u0016!\u00039sK\u001aL\u0007pS3z)\u0011\t)%a.\t\u0011\u0005\r\u0013\u0011\u0017a\u0001\u0003\u000b\u0002")
public class ZooKeeperStateStore
extends StateStore
implements Logging {
    private final String com$cloudera$livy$server$recovery$ZooKeeperStateStore$$zkAddress;
    private final String zkKeyPrefix;
    private final String retryValue;
    private final Regex retryPattern;
    private final RetryNTimes retryPolicy;
    private final CuratorFramework com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Option<CuratorFramework> $lessinit$greater$default$2() {
        return ZooKeeperStateStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static LivyConf.Entry ZK_RETRY_CONF() {
        return ZooKeeperStateStore$.MODULE$.ZK_RETRY_CONF();
    }

    public static LivyConf.Entry ZK_KEY_PREFIX_CONF() {
        return ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF();
    }

    private Logger logger$lzycompute() {
        ZooKeeperStateStore zooKeeperStateStore = this;
        synchronized (zooKeeperStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public String com$cloudera$livy$server$recovery$ZooKeeperStateStore$$zkAddress() {
        return this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$zkAddress;
    }

    private String zkKeyPrefix() {
        return this.zkKeyPrefix;
    }

    private String retryValue() {
        return this.retryValue;
    }

    private Regex retryPattern() {
        return this.retryPattern;
    }

    public RetryNTimes retryPolicy() {
        return this.retryPolicy;
    }

    public CuratorFramework com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient() {
        return this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient;
    }

    @Override
    public void set(String key, Object value) {
        String prefixedKey = this.prefixKey(key);
        byte[] data = this.serializeToBytes(value);
        if (this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null) {
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().create().creatingParentsIfNeeded().forPath(prefixedKey, data);
        } else {
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().setData().forPath(prefixedKey, data);
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        String prefixedKey = this.prefixKey(key);
        return this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null ? None$.MODULE$ : Option$.MODULE$.apply(this.deserialize((byte[])this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getData().forPath(prefixedKey), evidence$1));
    }

    @Override
    public Seq<String> getChildren(String key) {
        String prefixedKey = this.prefixKey(key);
        return this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().checkExists().forPath(prefixedKey) == null ? (Seq)Seq$.MODULE$.empty() : (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getChildren().forPath(prefixedKey)).asScala();
    }

    @Override
    public void remove(String key) {
        try {
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().delete().guaranteed().forPath(this.prefixKey(key));
        }
        catch (KeeperException.NoNodeException noNodeException) {}
    }

    private String prefixKey(String key) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkKeyPrefix(), key}));
    }

    public ZooKeeperStateStore(LivyConf livyConf, Option<CuratorFramework> mockCuratorClient) {
        super(livyConf);
        Logging.class.$init$((Logging)this);
        this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$zkAddress = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
        Predef$.MODULE$.require(!this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$zkAddress().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please config ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL().key()}));
            }
        });
        this.zkKeyPrefix = livyConf.get(ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF());
        this.retryValue = livyConf.get(ZooKeeperStateStore$.MODULE$.ZK_RETRY_CONF());
        this.retryPattern = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)\\s*,\\s*(\\d+)\\s*")).r();
        String string = this.retryValue();
        Option option = this.retryPattern().unapplySeq((Object)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            RetryNTimes retryNTimes;
            String n = (String)((LinearSeqOptimized)option.get()).apply(0);
            String sleepMs = (String)((LinearSeqOptimized)option.get()).apply(1);
            this.retryPolicy = retryNTimes = new RetryNTimes(new StringOps(Predef$.MODULE$.augmentString(n)).toInt(), new StringOps(Predef$.MODULE$.augmentString(sleepMs)).toInt());
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient = (CuratorFramework)mockCuratorClient.getOrElse((Function0)new $anonfun$2(this));
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ ZooKeeperStateStore $outer;

                public void run() {
                    this.$outer.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().close();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().getUnhandledErrorListenable().addListener((Object)new UnhandledErrorListener(this){
                private final /* synthetic */ ZooKeeperStateStore $outer;

                public void unhandledError(String message, Throwable e) {
                    this.$outer.error((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal Zookeeper error. Shutting down Livy server."})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    System.exit(1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.com$cloudera$livy$server$recovery$ZooKeeperStateStore$$curatorClient().start();
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " contains bad value: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZooKeeperStateStore$.MODULE$.ZK_KEY_PREFIX_CONF(), this.retryValue()}))).append((Object)"Correct format is <max retry count>,<sleep ms between retry>. e.g. 5,100").toString());
    }

    public ZooKeeperStateStore(LivyConf livyConf) {
        this(livyConf, (Option<CuratorFramework>)None$.MODULE$);
    }
}

