/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.sessions;

import com.cloudera.livy.LivyConf;
import com.cloudera.livy.LivyConf$;
import com.cloudera.livy.Logging;
import com.cloudera.livy.sessions.Session$;
import com.cloudera.livy.sessions.SessionState;
import com.cloudera.livy.utils.AppInfo;
import com.cloudera.livy.utils.AppInfo$;
import java.io.InputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUr!B\u0001\u0003\u0011\u0003Y\u0011aB*fgNLwN\u001c\u0006\u0003\u0007\u0011\t\u0001b]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tA\u0001\\5ws*\u0011q\u0001C\u0001\tG2|W\u000fZ3sC*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\u0004TKN\u001c\u0018n\u001c8\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017\u00199!$\u0004I\u0001$\u0003Y\"\u0001\u0005*fG>4XM]=NKR\fG-\u0019;b'\tI\u0002\u0003C\u0004\u001e3\t\u0007i\u0011\u0001\u0010\u0002\u0005%$W#A\u0010\u0011\u0005E\u0001\u0013BA\u0011\u0013\u0005\rIe\u000e\u001e\u0005\tG5A)\u0019!C\u0001I\u0005y1m\u001c8gS\u001e\u0014E.Y2l\u0019&\u001cH/F\u0001&!\r1\u0013\u0006\f\b\u0003#\u001dJ!\u0001\u000b\n\u0002\rA\u0013X\rZ3g\u0013\tQ3FA\u0002TKRT!\u0001\u000b\n\u0011\u0005\u0019j\u0013B\u0001\u0018,\u0005\u0019\u0019FO]5oO\"A\u0001'\u0004E\u0001B\u0003&Q%\u0001\td_:4\u0017n\u001a\"mC\u000e\\G*[:uA!)!'\u0004C\u0001g\u0005Y\u0001O]3qCJ,7i\u001c8g)\u001d!t'O$J\u00176\u0003BAJ\u001b-Y%\u0011ag\u000b\u0002\u0004\u001b\u0006\u0004\b\"\u0002\u001d2\u0001\u0004!\u0014\u0001B2p]\u001aDQAO\u0019A\u0002m\nAA[1sgB\u0019A\b\u0012\u0017\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\u000b\u0003\u0019a$o\\8u}%\t1#\u0003\u0002D%\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\r\u0019V-\u001d\u0006\u0003\u0007JAQ\u0001S\u0019A\u0002m\nQAZ5mKNDQAS\u0019A\u0002m\n\u0001\"\u0019:dQ&4Xm\u001d\u0005\u0006\u0019F\u0002\raO\u0001\baf4\u0015\u000e\\3t\u0011\u0015q\u0015\u00071\u0001P\u0003!a\u0017N^=D_:4\u0007C\u0001)R\u001b\u0005!\u0011B\u0001*\u0005\u0005!a\u0015N^=D_:4\u0007\"\u0002+\u000e\t\u0003)\u0016a\u0003:fg>dg/Z+S\u0013N$2a\u000f,Y\u0011\u001596\u000b1\u0001<\u0003\u0011)(/[:\t\u000b9\u001b\u0006\u0019A(\t\u000bikA\u0011A.\u0002\u0015I,7o\u001c7wKV\u0013\u0016\nF\u0002]I\u001a\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u00079,GOC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&aA+S\u0013\")Q-\u0017a\u00019\u0006\u0019QO]5\t\u000b9K\u0006\u0019A(\u0007\u000b9\u0011\u0011\u0011\u00015\u0014\u0007\u001d\u0004\u0012\u000e\u0005\u0002QU&\u00111\u000e\u0002\u0002\b\u0019><w-\u001b8h\u0011!irM!b\u0001\n\u0003q\u0002\u0002\u00038h\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0007%$\u0007\u0005\u0003\u0005qO\n\u0015\r\u0011\"\u0001r\u0003\u0015ywO\\3s+\u0005a\u0003\u0002C:h\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\r=<h.\u001a:!\u0011!quM!b\u0001\n\u0003)X#A(\t\u0011]<'\u0011!Q\u0001\n=\u000b\u0011\u0002\\5ws\u000e{gN\u001a\u0011\t\u000b]9G\u0011A=\u0015\ti\\H0 \t\u0003\u0019\u001dDQ!\b=A\u0002}AQ\u0001\u001d=A\u00021BQA\u0014=A\u0002=C\u0001b`4C\u0002\u0013M\u0011\u0011A\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u0013\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001b\t9A\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_JD\u0001\"!\u0005hA\u0003%\u00111A\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003\"CA\u000bO\u0002\u0007I\u0011CA\f\u0003\u0019y\u0016\r\u001d9JIV\u0011\u0011\u0011\u0004\t\u0005#\u0005mA&C\u0002\u0002\u001eI\u0011aa\u00149uS>t\u0007\"CA\u0011O\u0002\u0007I\u0011CA\u0012\u0003)y\u0016\r\u001d9JI~#S-\u001d\u000b\u0005\u0003K\tY\u0003E\u0002\u0012\u0003OI1!!\u000b\u0013\u0005\u0011)f.\u001b;\t\u0015\u00055\u0012qDA\u0001\u0002\u0004\tI\"A\u0002yIEB\u0001\"!\rhA\u0003&\u0011\u0011D\u0001\b?\u0006\u0004\b/\u00133!\u0011%\t)d\u001aa\u0001\n\u0013\t9$A\u0007`Y\u0006\u001cH/Q2uSZLG/_\u000b\u0003\u0003s\u00012!EA\u001e\u0013\r\tiD\u0005\u0002\u0005\u0019>tw\rC\u0005\u0002B\u001d\u0004\r\u0011\"\u0003\u0002D\u0005\tr\f\\1ti\u0006\u001bG/\u001b<jif|F%Z9\u0015\t\u0005\u0015\u0012Q\t\u0005\u000b\u0003[\ty$!AA\u0002\u0005e\u0002\u0002CA%O\u0002\u0006K!!\u000f\u0002\u001d}c\u0017m\u001d;BGRLg/\u001b;zA!I\u0011QJ4A\u0002\u0013%\u0011qJ\u0001\u000bgR\fw-\u001b8h\t&\u0014XCAA)!\u0011\t\u0019&!\u001a\u000e\u0005\u0005U#\u0002BA,\u00033\n!AZ:\u000b\t\u0005m\u0013QL\u0001\u0007Q\u0006$wn\u001c9\u000b\t\u0005}\u0013\u0011M\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0014aA8sO&!\u0011qMA+\u0005\u0011\u0001\u0016\r\u001e5\t\u0013\u0005-t\r1A\u0005\n\u00055\u0014AD:uC\u001eLgn\u001a#je~#S-\u001d\u000b\u0005\u0003K\ty\u0007\u0003\u0006\u0002.\u0005%\u0014\u0011!a\u0001\u0003#B\u0001\"a\u001dhA\u0003&\u0011\u0011K\u0001\fgR\fw-\u001b8h\t&\u0014\b\u0005C\u0004\u0002x\u001d$\t!a\u0006\u0002\u000b\u0005\u0004\b/\u00133\t\u0013\u0005mt\r1A\u0005\u0002\u0005u\u0014aB1qa&sgm\\\u000b\u0003\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000b#\u0011!B;uS2\u001c\u0018\u0002BAE\u0003\u0007\u0013q!\u00119q\u0013:4w\u000eC\u0005\u0002\u000e\u001e\u0004\r\u0011\"\u0001\u0002\u0010\u0006Y\u0011\r\u001d9J]\u001a|w\fJ3r)\u0011\t)#!%\t\u0015\u00055\u00121RA\u0001\u0002\u0004\ty\b\u0003\u0005\u0002\u0016\u001e\u0004\u000b\u0015BA@\u0003!\t\u0007\u000f]%oM>\u0004\u0003bBAMO\u0012\u0005\u0011qG\u0001\rY\u0006\u001cH/Q2uSZLG/\u001f\u0005\b\u0003;;g\u0011AAP\u0003!awn\u001a'j]\u0016\u001cHCAAQ!\u0011a\u00141\u0015\u0017\n\u0007\u0005\u0015fI\u0001\u0006J]\u0012,\u00070\u001a3TKFDq!!+h\t\u0003\tY+\u0001\bsK\u000e|'\u000fZ!di&4\u0018\u000e^=\u0015\u0005\u0005\u0015\u0002bBAXO\u001a\u0005\u0011\u0011W\u0001\u0011e\u0016\u001cwN^3ss6+G/\u00193bi\u0006,\"!a-\u0011\u0007\u0005U\u0016D\u0004\u0002\r\u0001!9\u0011\u0011X4\u0007\u0002\u0005m\u0016!B:uCR,WCAA_!\ra\u0011qX\u0005\u0004\u0003\u0003\u0014!\u0001D*fgNLwN\\*uCR,\u0007bBAcO\u0012\u0005\u0011qY\u0001\u0005gR|\u0007\u000f\u0006\u0002\u0002JB1\u0011QAAf\u0003KIA!!4\u0002\b\t1a)\u001e;ve\u0016D\u0011\"!5h\u0005\u0004%\t!a\u000e\u0002\u000fQLW.Z8vi\"A\u0011Q[4!\u0002\u0013\tI$\u0001\u0005uS6,w.\u001e;!\u0011\u001d\tIn\u001aC!\u00037\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002Y!9\u0011q\\4\u0007\u0012\u0005-\u0016aC:u_B\u001cVm]:j_:D\u0011\"a9h\u0005\u00045\t\"a\u0006\u0002\u0013A\u0014x\u000e_=Vg\u0016\u0014\bbBAtO\u0012E\u0011\u0011^\u0001\nI>\f5oT<oKJ,B!a;\u0002rR!\u0011Q\u001eB\u0002!\u0011\ty/!=\r\u0001\u0011A\u00111_As\u0005\u0004\t)PA\u0001U#\u0011\t90!@\u0011\u0007E\tI0C\u0002\u0002|J\u0011qAT8uQ&tw\rE\u0002\u0012\u0003\u007fL1A!\u0001\u0013\u0005\r\te.\u001f\u0005\n\u0005\u000b\t)\u000f\"a\u0001\u0005\u000f\t!A\u001a8\u0011\u000bE\u0011I!!<\n\u0007\t-!C\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011ya\u001aC\t\u0005#\t!cY8qsJ+7o\\;sG\u0016$v\u000e\u0013#G'R)ALa\u0005\u0003$!A!Q\u0003B\u0007\u0001\u0004\u00119\"\u0001\u0006eCR\f7\u000b\u001e:fC6\u0004BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;\u0001\u0017AA5p\u0013\u0011\u0011\tCa\u0007\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0005K\u0011i\u00011\u0001-\u0003\u0011q\u0017-\\3\t\u000f\t%r\r\"\u0003\u0003,\u0005iq-\u001a;Ti\u0006<\u0017N\\4ESJ$B!!\u0015\u0003.!A\u0011q\u000bB\u0014\u0001\u0004\u0011y\u0003\u0005\u0003\u0002T\tE\u0012\u0002\u0002B\u001a\u0003+\u0012!BR5mKNK8\u000f^3n\u0001")
public abstract class Session
implements Logging {
    private final int id;
    private final String owner;
    private final LivyConf livyConf;
    private final ExecutionContextExecutor executionContext;
    private Option<String> _appId;
    private long _lastActivity;
    private Path com$cloudera$livy$sessions$Session$$stagingDir;
    private AppInfo appInfo;
    private final long timeout;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static URI resolveURI(URI uRI, LivyConf livyConf) {
        return Session$.MODULE$.resolveURI(uRI, livyConf);
    }

    public static Seq<String> resolveURIs(Seq<String> seq, LivyConf livyConf) {
        return Session$.MODULE$.resolveURIs(seq, livyConf);
    }

    public static Map<String, String> prepareConf(Map<String, String> map, Seq<String> seq, Seq<String> seq2, Seq<String> seq3, Seq<String> seq4, LivyConf livyConf) {
        return Session$.MODULE$.prepareConf(map, seq, seq2, seq3, seq4, livyConf);
    }

    public static Set<String> configBlackList() {
        return Session$.MODULE$.configBlackList();
    }

    private Logger logger$lzycompute() {
        Session session = this;
        synchronized (session) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public int id() {
        return this.id;
    }

    public String owner() {
        return this.owner;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public Option<String> _appId() {
        return this._appId;
    }

    public void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private long _lastActivity() {
        return this._lastActivity;
    }

    private void _lastActivity_$eq(long x$1) {
        this._lastActivity = x$1;
    }

    public Path com$cloudera$livy$sessions$Session$$stagingDir() {
        return this.com$cloudera$livy$sessions$Session$$stagingDir;
    }

    private void com$cloudera$livy$sessions$Session$$stagingDir_$eq(Path x$1) {
        this.com$cloudera$livy$sessions$Session$$stagingDir = x$1;
    }

    public Option<String> appId() {
        return this._appId();
    }

    public AppInfo appInfo() {
        return this.appInfo;
    }

    public void appInfo_$eq(AppInfo x$1) {
        this.appInfo = x$1;
    }

    public long lastActivity() {
        long l;
        SessionState sessionState = this.state();
        if (sessionState instanceof SessionState.Error) {
            long time;
            SessionState.Error error = (SessionState.Error)sessionState;
            l = time = error.time();
        } else if (sessionState instanceof SessionState.Dead) {
            long time;
            SessionState.Dead dead = (SessionState.Dead)sessionState;
            l = time = dead.time();
        } else if (sessionState instanceof SessionState.Success) {
            long time;
            SessionState.Success success = (SessionState.Success)sessionState;
            l = time = success.time();
        } else {
            l = this._lastActivity();
        }
        return l;
    }

    public abstract IndexedSeq<String> logLines();

    public void recordActivity() {
        this._lastActivity_$eq(System.nanoTime());
    }

    public abstract RecoveryMetadata recoveryMetadata();

    public abstract SessionState state();

    public Future<BoxedUnit> stop() {
        return Future$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.stopSession();
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<Object>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;
                        private final Exception e$1;

                        public final Tuple2<String, Exception> apply() {
                            return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error stopping session ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().id())})), (Object)this.e$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    });
                }
                try {
                    if (this.$outer.com$cloudera$livy$sessions$Session$$stagingDir() != null) {
                        this.$outer.debug((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$stop$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting session ", " staging directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().id()), this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().com$cloudera$livy$sessions$Session$$stagingDir()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.doAsOwner(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$stop$1 $outer;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                FileSystem fs = FileSystem.newInstance((Configuration)this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().livyConf().hadoopConf());
                                try {
                                    return fs.delete(this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().com$cloudera$livy$sessions$Session$$stagingDir(), true);
                                }
                                finally {
                                    fs.close();
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<Object>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;
                        private final Exception e$2;

                        public final Tuple2<String, Exception> apply() {
                            return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error cleaning up session ", " staging dir."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.com$cloudera$livy$sessions$Session$$anonfun$$$outer().id())})), (Object)this.e$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$2 = e$2;
                        }
                    });
                }
            }

            public /* synthetic */ Session com$cloudera$livy$sessions$Session$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.executionContext());
    }

    public long timeout() {
        return this.timeout;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public abstract void stopSession();

    public abstract Option<String> proxyUser();

    public <T> T doAsOwner(Function0<T> fn) {
        Object object;
        String user = (String)this.proxyUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;

            public final String apply() {
                return this.$outer.owner();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (user == null) {
            object = fn.apply();
        } else {
            UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? (this.livyConf().getBoolean(LivyConf$.MODULE$.IMPERSONATION_ENABLED()) ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser()) : UserGroupInformation.getCurrentUser()) : UserGroupInformation.createRemoteUser((String)user);
            object = ugi.doAs(new PrivilegedExceptionAction<T>(this, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        return (T)object;
    }

    public URI copyResourceToHDFS(InputStream dataStream, String name) {
        return (URI)this.doAsOwner((Function0)new Serializable(this, dataStream, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;
            private final InputStream dataStream$1;
            private final String name$1;

            /*
             * WARNING - void declaration
             */
            public final URI apply() {
                FileSystem fs = FileSystem.newInstance((Configuration)this.$outer.livyConf().hadoopConf());
                try {
                    Path filePath = new Path(this.$outer.com$cloudera$livy$sessions$Session$$getStagingDir(fs), this.name$1);
                    this.$outer.debug((Function0<Object>)new Serializable(this, filePath){
                        public static final long serialVersionUID = 0L;
                        private final Path filePath$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading user file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filePath$1}));
                        }
                        {
                            this.filePath$1 = filePath$1;
                        }
                    });
                    FSDataOutputStream outFile = fs.create(filePath, true);
                    byte[] buffer = new byte[524288];
                    int read = -1;
                    try {
                        while ((read = this.dataStream$1.read(buffer)) != -1) {
                            outFile.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable) {
                        void var4_3;
                        var4_3.close();
                        throw throwable;
                    }
                    outFile.close();
                    return filePath.toUri();
                }
                finally {
                    fs.close();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataStream$1 = dataStream$1;
                this.name$1 = name$1;
            }
        });
    }

    public synchronized Path com$cloudera$livy$sessions$Session$$getStagingDir(FileSystem fs) {
        if (this.com$cloudera$livy$sessions$Session$$stagingDir() == null) {
            String stagingRoot = (String)Option$.MODULE$.apply((Object)this.livyConf().get(LivyConf$.MODULE$.SESSION_STAGING_DIR())).getOrElse((Function0)new Serializable(this, fs){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$1;

                public final String apply() {
                    return new Path(this.fs$1.getHomeDirectory(), ".livy-sessions").toString();
                }
                {
                    this.fs$1 = fs$1;
                }
            });
            Path sessionDir = new Path(stagingRoot, UUID.randomUUID().toString());
            fs.mkdirs(sessionDir);
            fs.setPermission(sessionDir, new FsPermission("700"));
            this.com$cloudera$livy$sessions$Session$$stagingDir_$eq(sessionDir);
            this.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Session $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Session ", " staging directory is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id()), this.$outer.com$cloudera$livy$sessions$Session$$stagingDir()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.com$cloudera$livy$sessions$Session$$stagingDir();
    }

    public Session(int id, String owner, LivyConf livyConf) {
        this.id = id;
        this.owner = owner;
        this.livyConf = livyConf;
        Logging.class.$init$((Logging)this);
        this.executionContext = ExecutionContext$.MODULE$.global();
        this._appId = None$.MODULE$;
        this._lastActivity = System.nanoTime();
        this.com$cloudera$livy$sessions$Session$$stagingDir = null;
        this.appInfo = new AppInfo(AppInfo$.MODULE$.apply$default$1(), AppInfo$.MODULE$.apply$default$2());
        this.timeout = TimeUnit.HOURS.toNanos(1L);
    }

    public static interface RecoveryMetadata {
        public int id();
    }
}

