/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.sessions;

import com.cloudera.livy.LivyConf;
import com.cloudera.livy.LivyConf$;
import com.cloudera.livy.Logging;
import com.cloudera.livy.server.recovery.SessionStore;
import com.cloudera.livy.sessions.Session;
import com.cloudera.livy.sessions.SessionManager$;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5r!B\u0001\u0003\u0011\u0003Y\u0011AD*fgNLwN\\'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t\u0001b]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tA\u0001\\5ws*\u0011q\u0001C\u0001\tG2|W\u000fZ3sC*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\bTKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9!$\u0004b\u0001\n\u0003Y\u0012!G*F'NKuJT0S\u000b\u000e{e+\u0012*Z?6{E)R0P\r\u001a+\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q%\u0004Q\u0001\nq\t!dU#T'&{ej\u0018*F\u0007>3VIU-`\u001b>#UiX(G\r\u0002BqaJ\u0007C\u0002\u0013\u00051$\u0001\u0010T\u000bN\u001b\u0016j\u0014(`%\u0016\u001buJV#S3~ku\nR#`%\u0016\u001buJV#S3\"1\u0011&\u0004Q\u0001\nq\tqdU#T'&{ej\u0018*F\u0007>3VIU-`\u001b>#Ui\u0018*F\u0007>3VIU-!\u0011\u001dYSB1A\u0005\u00021\nqbU#T'&{ej\u0018+J\u001b\u0016{U\u000bV\u000b\u0002[A\u0011aF\r\b\u0003_Aj\u0011\u0001B\u0005\u0003c\u0011\t\u0001\u0002T5ws\u000e{gNZ\u0005\u0003gQ\u0012Q!\u00128uefT!!\r\u0003\t\rYj\u0001\u0015!\u0003.\u0003A\u0019ViU*J\u001f:{F+S'F\u001fV#\u0006\u0005C\u00049\u001bE\u0005I\u0011A\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\rQ\u0004*U\u000b\u0002w)\u0012Ah\u0010\b\u0003#uJ!A\u0010\n\u0002\t9{g.Z\u0016\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0012\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002H\u0005\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b%;$\u0019\u0001&\u0003\u0003M\u000b\"a\u0013(\u0011\u0005Ea\u0015BA'\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001D(\n\u0005A\u0013!aB*fgNLwN\u001c\u0003\u0006%^\u0012\ra\u0015\u0002\u0002%F\u00111\n\u0016\t\u0003+\u000et!AV1\u000f\u0005]\u0003gB\u0001-`\u001d\tIfL\u0004\u0002[;6\t1L\u0003\u0002]\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011B\u00012\u0003\u0003\u001d\u0019Vm]:j_:L!\u0001Z3\u0003!I+7m\u001c<feflU\r^1eCR\f'B\u00012\u0003\r\u0011q!\u0001A4\u0016\u0007!l8pE\u0002g!%\u0004\"a\f6\n\u0005-$!a\u0002'pO\u001eLgn\u001a\u0005\t[\u001a\u0014)\u0019!C\t]\u0006AA.\u001b<z\u0007>tg-F\u0001p!\ty\u0003/\u0003\u0002r\t\tAA*\u001b<z\u0007>tg\r\u0003\u0005tM\n\u0005\t\u0015!\u0003p\u0003%a\u0017N^=D_:4\u0007\u0005\u0003\u0005vM\n\u0005\t\u0015!\u0003w\u0003=\u0019Xm]:j_:\u0014VmY8wKJL\b\u0003B\txsrL!\u0001\u001f\n\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001>|\u0019\u0001!QA\u00154C\u0002M\u0003\"A_?\u0005\u000b%3'\u0019\u0001&\t\u0013}4'\u0011!Q\u0001\n\u0005\u0005\u0011\u0001D:fgNLwN\\*u_J,\u0007\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\te\u0016\u001cwN^3ss*\u0019\u00111\u0002\u0003\u0002\rM,'O^3s\u0013\u0011\ty!!\u0002\u0003\u0019M+7o]5p]N#xN]3\t\u0015\u0005MaM!A!\u0002\u0013\t)\"A\u0006tKN\u001c\u0018n\u001c8UsB,\u0007\u0003BA\f\u0003;q1!EA\r\u0013\r\tYBE\u0001\u0007!J,G-\u001a4\n\u0007\r\nyBC\u0002\u0002\u001cIA!\"a\tg\u0005\u0003\u0005\u000b\u0011BA\u0013\u00031iwnY6TKN\u001c\u0018n\u001c8t!\u0015\t\u0012qEA\u0016\u0013\r\tIC\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u00055\u0012q\u0007?\u000f\t\u0005=\u00121\u0007\b\u00045\u0006E\u0012\"A\n\n\u0007\u0005U\"#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00121\b\u0002\u0004'\u0016\f(bAA\u001b%!Q\u0011q\b4\u0003\u0004\u0003\u0006Y!!\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0003\u0002D\u0005%\u00130\u0004\u0002\u0002F)\u0019\u0011q\t\n\u0002\u000fI,g\r\\3di&!\u00111JA#\u0005!\u0019E.Y:t)\u0006<\u0007BB\fg\t\u0003\ty\u0005\u0006\u0007\u0002R\u0005]\u0013\u0011LA.\u0003;\ny\u0006\u0006\u0003\u0002T\u0005U\u0003\u0003\u0002\u0007gyfD\u0001\"a\u0010\u0002N\u0001\u000f\u0011\u0011\t\u0005\u0007[\u00065\u0003\u0019A8\t\rU\fi\u00051\u0001w\u0011\u001dy\u0018Q\na\u0001\u0003\u0003A\u0001\"a\u0005\u0002N\u0001\u0007\u0011Q\u0003\u0005\u000b\u0003G\ti\u0005%AA\u0002\u0005\u0015\u0002bBA2M\u0012M\u0011QM\u0001\tKb,7-\u001e;peV\u0011\u0011q\r\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\n\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002r\u0005-$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011%\t)H\u001ab!\n+\t9(A\u0005jI\u000e{WO\u001c;feV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n9)\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0019\tGo\\7jG*!\u0011QNAB\u0015\r\t)\tI\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0006u$!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005\u0002\u000e\u001a\u0004\u000bQBA=\u0003)IGmQ8v]R,'\u000f\t\u0005\t\u0007\u0019\u0014\r\u0015\"\u0006\u0002\u0012V\u0011\u00111\u0013\t\b\u0003+\u000by*a)}\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003;\u0013\u0012AC2pY2,7\r^5p]&!\u0011\u0011UAL\u00055a\u0015N\\6fI\"\u000b7\u000f['baB\u0019\u0011#!*\n\u0007\u0005\u001d&CA\u0002J]RD\u0001\"a+gA\u00035\u00111S\u0001\ng\u0016\u001c8/[8og\u0002B\u0001\"a,gA\u00035\u0011\u0011W\u0001\u000fg\u0016\u001c8/[8o)&lWm\\;u!\r\t\u00121W\u0005\u0004\u0003k\u0013\"\u0001\u0002'p]\u001eDq!!/g\t\u0003\tY,\u0001\u0004oKb$\u0018\n\u001a\u000b\u0003\u0003GCq!a0g\t\u0003\t\t-\u0001\u0005sK\u001eL7\u000f^3s)\ra\u00181\u0019\u0005\b\u0003\u000b\fi\f1\u0001}\u0003\u001d\u0019Xm]:j_:Dq!!3g\t\u0003\tY-A\u0002hKR$B!!4\u0002PB!\u0011#a\n}\u0011!\t\t.a2A\u0002\u0005\r\u0016AA5e\u0011\u001d\t)N\u001aC\u0001\u0003w\u000bAa]5{K\"9\u0011\u0011\u001c4\u0005\u0002\u0005m\u0017aA1mYR\u0011\u0011Q\u001c\t\u0006\u0003[\ty\u000e`\u0005\u0005\u0003C\fYD\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t)O\u001aC\u0001\u0003O\fa\u0001Z3mKR,G\u0003BAu\u0003o\u0004R!EA\u0014\u0003W\u0004b!!\u001b\u0002n\u0006E\u0018\u0002BAx\u0003W\u0012aAR;ukJ,\u0007cA\t\u0002t&\u0019\u0011Q\u001f\n\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003#\f\u0019\u000f1\u0001\u0002$\"9\u0011Q\u001d4\u0005\u0002\u0005mH\u0003BAv\u0003{Dq!!2\u0002z\u0002\u0007A\u0010C\u0004\u0003\u0002\u0019$\tAa\u0001\u0002\u0011MDW\u000f\u001e3po:$\"!!=\t\u000f\t\u001da\r\"\u0001\u0003\n\u0005q1m\u001c7mK\u000e$x)\u0019:cC\u001e,GC\u0001B\u0006!\u0019\tI'!<\u0003\u000eA1\u0011QFAp\u0003cDqA!\u0005g\t\u0013\u0011\u0019\"A\u0004sK\u000e|g/\u001a:\u0015\u0005\u0005-bA\u0002B\fM\u0012\u0011IB\u0001\tHCJ\u0014\u0017mZ3D_2dWm\u0019;peN!!Q\u0003B\u000e!\ri\"QD\u0005\u0004\u0005?q\"A\u0002+ie\u0016\fG\rC\u0004\u0018\u0005+!\tAa\t\u0015\u0005\t\u0015\u0002\u0003\u0002B\u0014\u0005+i\u0011A\u001a\u0005\t\u0005W\u0011)\u0002\"\u0011\u0003\u0004\u0005\u0019!/\u001e8")
public class SessionManager<S extends Session, R extends Session.RecoveryMetadata>
implements Logging {
    private final LivyConf livyConf;
    private final Function1<R, S> sessionRecovery;
    public final SessionStore com$cloudera$livy$sessions$SessionManager$$sessionStore;
    public final String com$cloudera$livy$sessions$SessionManager$$sessionType;
    private final ClassTag<R> evidence$1;
    private final AtomicInteger idCounter;
    private final LinkedHashMap<Object, S> sessions;
    private final long sessionTimeout;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static <S extends Session, R extends Session.RecoveryMetadata> None$ $lessinit$greater$default$5() {
        return SessionManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static LivyConf.Entry SESSION_TIMEOUT() {
        return SessionManager$.MODULE$.SESSION_TIMEOUT();
    }

    public static String SESSION_RECOVERY_MODE_RECOVERY() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_RECOVERY();
    }

    public static String SESSION_RECOVERY_MODE_OFF() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
    }

    private Logger logger$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContext executor() {
        return ExecutionContext$.MODULE$.global();
    }

    public final AtomicInteger idCounter() {
        return this.idCounter;
    }

    public final LinkedHashMap<Object, S> sessions() {
        return this.sessions;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int nextId() {
        void var1_1;
        int id = this.idCounter().getAndIncrement();
        this.com$cloudera$livy$sessions$SessionManager$$sessionStore.saveNextSessionId(this.com$cloudera$livy$sessions$SessionManager$$sessionType, this.idCounter().get());
        return (int)var1_1;
    }

    public S register(S session) {
        this.info((Function0<Object>)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final Session session$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering new session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.session$2.id())}));
            }
            {
                this.session$2 = session$2;
            }
        });
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)((Session)session).id()), session);
            return session;
        }
    }

    public Option<S> get(int id) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)id));
    }

    public int size() {
        return this.sessions().size();
    }

    public Iterable<S> all() {
        return this.sessions().values();
    }

    public Option<Future<BoxedUnit>> delete(int id) {
        return this.get(id).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final Future<BoxedUnit> apply(S session) {
                return this.$outer.delete(session);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Future<BoxedUnit> delete(S session) {
        return ((Session)session).stop().map((Function1)new Serializable(this, session){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;
            private final Session session$1;

            public final void apply(BoxedUnit x0$1) {
                BoxedUnit boxedUnit = x0$1;
                this.$outer.com$cloudera$livy$sessions$SessionManager$$sessionStore.remove(this.$outer.com$cloudera$livy$sessions$SessionManager$$sessionType, this.session$1.id());
                SessionManager sessionManager = this.$outer;
                synchronized (sessionManager) {
                    try {
                        this.$outer.sessions().remove((Object)BoxesRunTime.boxToInteger((int)this.session$1.id()));
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl9 : MonitorExitStatement: MONITOREXIT : var9_3
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            Option option = NonFatal$.MODULE$.unapply(throwable3);
                            if (option.isEmpty()) {
                                throw throwable2;
                            }
                            Throwable e = (Throwable)option.get();
                            this.$outer.error((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Exception was thrown during stop session:";
                                }
                            }, e);
                            throw e;
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.session$1 = session$1;
            }
        }, this.executor());
    }

    public void shutdown() {
        boolean recoveryEnabled;
        String string = this.livyConf().get(LivyConf$.MODULE$.RECOVERY_MODE());
        String string2 = SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? false : (recoveryEnabled = true);
        if (!recoveryEnabled) {
            ((IterableLike)this.sessions().values().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<BoxedUnit> apply(S x$3) {
                    return ((Session)x$3).stop();
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<BoxedUnit> apply(Future<BoxedUnit> future) {
                    return (Future)Await$.MODULE$.ready(future, (Duration)Duration$.MODULE$.Inf());
                }
            });
        }
    }

    public Future<Iterable<BoxedUnit>> collectGarbage() {
        return Future$.MODULE$.sequence((TraversableOnce)((TraversableLike)this.all().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final boolean apply(Session session) {
                return this.$outer.com$cloudera$livy$sessions$SessionManager$$expired$1(session);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final Future<BoxedUnit> apply(S session) {
                return this.$outer.delete(session);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), this.executor());
    }

    /*
     * WARNING - void declaration
     */
    public Seq<S> com$cloudera$livy$sessions$SessionManager$$recover() {
        void var2_2;
        this.idCounter().set(this.com$cloudera$livy$sessions$SessionManager$$sessionStore.getNextSessionId(this.com$cloudera$livy$sessions$SessionManager$$sessionType));
        Seq<Try<R>> sessionMetadata = this.com$cloudera$livy$sessions$SessionManager$$sessionStore.getAllSessions(this.com$cloudera$livy$sessions$SessionManager$$sessionType, this.evidence$1);
        Seq recoveredSessions = (Seq)((TraversableLike)sessionMetadata.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<R> apply(Try<R> x$4) {
                return Option$.MODULE$.option2Iterable(x$4.toOption());
            }
        }, Seq$.MODULE$.canBuildFrom())).map(this.sessionRecovery, Seq$.MODULE$.canBuildFrom());
        this.info((Function0<Object>)new Serializable(this, recoveredSessions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;
            private final Seq recoveredSessions$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered ", " ", " sessions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.recoveredSessions$1.length()), this.$outer.com$cloudera$livy$sessions$SessionManager$$sessionType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Next session id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.idCounter()}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.recoveredSessions$1 = recoveredSessions$1;
            }
        });
        Seq recoveryFailure = (Seq)((TraversableLike)sessionMetadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Try<R> x$5) {
                return x$5.isFailure();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Throwable apply(Try<R> x$6) {
                return (Throwable)x$6.failed().get();
            }
        }, Seq$.MODULE$.canBuildFrom());
        recoveryFailure.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final void apply(Throwable ex) {
                this.$outer.error((Function0<Object>)new Serializable(this, ex){
                    public static final long serialVersionUID = 0L;
                    private final Throwable ex$1;

                    public final String apply() {
                        return this.ex$1.getMessage();
                    }
                    {
                        this.ex$1 = ex$1;
                    }
                }, ex.getCause());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return var2_2;
    }

    public final boolean com$cloudera$livy$sessions$SessionManager$$expired$1(Session session) {
        long currentTime = System.nanoTime();
        return currentTime - session.lastActivity() > package$.MODULE$.max(this.sessionTimeout, session.timeout());
    }

    public SessionManager(LivyConf livyConf, Function1<R, S> sessionRecovery, SessionStore sessionStore, String sessionType, Option<Seq<S>> mockSessions, ClassTag<R> evidence$1) {
        this.livyConf = livyConf;
        this.sessionRecovery = sessionRecovery;
        this.com$cloudera$livy$sessions$SessionManager$$sessionStore = sessionStore;
        this.com$cloudera$livy$sessions$SessionManager$$sessionType = sessionType;
        this.evidence$1 = evidence$1;
        Logging.class.$init$((Logging)this);
        this.idCounter = new AtomicInteger(0);
        this.sessions = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.sessionTimeout = TimeUnit.MILLISECONDS.toNanos(livyConf.getTimeAsMs(SessionManager$.MODULE$.SESSION_TIMEOUT()));
        ((IterableLike)mockSessions.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final Seq<S> apply() {
                return this.$outer.com$cloudera$livy$sessions$SessionManager$$recover();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionManager $outer;

            public final S apply(S session) {
                return this.$outer.register(session);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        new GarbageCollector().start();
    }

    public class GarbageCollector
    extends Thread {
        @Override
        public void run() {
            while (true) {
                this.com$cloudera$livy$sessions$SessionManager$GarbageCollector$$$outer().collectGarbage();
                Thread.sleep(60000L);
            }
        }

        public /* synthetic */ SessionManager com$cloudera$livy$sessions$SessionManager$GarbageCollector$$$outer() {
            return SessionManager.this;
        }

        public GarbageCollector() {
            if (SessionManager.this == null) {
                throw new NullPointerException();
            }
            super("session gc thread");
            this.setDaemon(true);
        }
    }
}

