/*
 * Copyright (c) 2016 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;

/**
 * Represents a View definition to store and load.
 *
 * Use {@link DefaultView} create methods to build "classic" views and
 * {@link SpatialView} create methods to build spatial/dimensional views.
 *
 * @author Michael Nitschinger
 * @since 2.0
 */
@InterfaceStability.Committed
@InterfaceAudience.Public
public interface View {

    /**
     * The name of the view.
     *
     * @return the name.
     */
    String name();

    /**
     * The map function
     *
     * @return map function.
     */
    String map();

    /**
     * The reduce function.
     *
     * @return reduce function, or null if none is set.
     */
    String reduce();

    /**
     * If a reduce function is set or not.
     *
     * @return true if it is, false otherwise.
     */
    boolean hasReduce();

}
