/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.subdoc.SubdocOptionsBuilder;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class MutationSpec {
    private final Mutation type;
    private final String path;
    private final Object fragment;
    private final boolean createParents;
    private final boolean attributeAccess;

    @Deprecated
    public MutationSpec(Mutation type, String path, Object fragment, boolean createParents) {
        this.type = type;
        this.path = path;
        this.fragment = fragment;
        this.createParents = createParents;
        this.attributeAccess = false;
    }

    public MutationSpec(Mutation type, String path, Object fragment, SubdocOptionsBuilder builder) {
        this.type = type;
        this.path = path;
        this.fragment = fragment;
        this.createParents = builder.createParents();
        this.attributeAccess = builder.attributeAccess();
    }

    public MutationSpec(Mutation type, String path, Object fragment) {
        this.type = type;
        this.path = path;
        this.fragment = fragment;
        this.createParents = false;
        this.attributeAccess = false;
    }

    public Mutation type() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public Object fragment() {
        return this.fragment;
    }

    public boolean createParents() {
        return this.createParents;
    }

    public boolean attributeAccess() {
        return this.attributeAccess;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.type());
        if (this.createParents) {
            sb.append(", createParents");
        }
        if (this.attributeAccess) {
            sb.append(", attributeAccess");
        }
        sb.append(':').append(this.path()).append('}');
        return sb.toString();
    }
}

