/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Volatile
public class JsonObjectCrypto {
    private final CryptoManager cryptoManager;
    private final String encrypterAlias;
    private final JsonObject wrapped;

    protected JsonObjectCrypto(JsonObject jsonObject, CryptoManager cryptoManager, String encrypterAlias) {
        this.wrapped = Objects.requireNonNull(jsonObject);
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
        this.encrypterAlias = (String)CbObjects.defaultIfNull((Object)encrypterAlias, (Object)"__DEFAULT__");
    }

    public JsonObjectCrypto withEncrypter(String encrypterAlias) {
        return new JsonObjectCrypto(this.wrapped, this.cryptoManager, encrypterAlias);
    }

    public JsonObjectCrypto withDefaultEncrypter() {
        return new JsonObjectCrypto(this.wrapped, this.cryptoManager, null);
    }

    public JsonObjectCrypto withObject(JsonObject object) {
        return new JsonObjectCrypto(object, this.cryptoManager, this.encrypterAlias);
    }

    public JsonObject object() {
        return this.wrapped;
    }

    public boolean hasEncryptedField(String fieldName) {
        return this.wrapped.getNames().contains(this.cryptoManager.mangle(fieldName));
    }

    public Set<String> getEncryptedFieldNames() {
        return this.wrapped.getNames().stream().filter(arg_0 -> ((CryptoManager)this.cryptoManager).isMangled(arg_0)).map(arg_0 -> ((CryptoManager)this.cryptoManager).demangle(arg_0)).collect(Collectors.toSet());
    }

    public Set<String> getUnencryptedFieldNames() {
        return this.wrapped.getNames().stream().filter(name -> !this.cryptoManager.isMangled(name)).collect(Collectors.toSet());
    }

    public JsonObjectCrypto put(String fieldName, Object fieldValue) {
        if (this.wrapped == fieldValue) {
            throw new IllegalArgumentException("Cannot put self");
        }
        fieldValue = JsonValue.coerce(fieldValue);
        try {
            byte[] plaintext = JsonObjectCrypto.mapper().writeValueAsBytes(fieldValue);
            this.wrapped.put(this.cryptoManager.mangle(fieldName), this.cryptoManager.encrypt(plaintext, this.encrypterAlias));
            return this;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("JSON serialization failed", e);
        }
    }

    private JsonObject decrypt(String fieldName) {
        JsonObject encryptedValue = this.wrapped.getObject(this.cryptoManager.mangle(fieldName));
        if (encryptedValue == null) {
            return JsonObject.create();
        }
        byte[] plaintext = this.cryptoManager.decrypt(encryptedValue.toMap());
        ObjectNode decrypted = (ObjectNode)JsonObjectCrypto.mapper().createObjectNode().set(fieldName, Mapper.decodeIntoTree((byte[])plaintext));
        return (JsonObject)JsonObjectCrypto.mapper().convertValue((Object)decrypted, JsonObject.class);
    }

    private static ObjectMapper mapper() {
        return JacksonTransformers.MAPPER;
    }

    public Object get(String fieldName) {
        return this.decrypt(fieldName).get(fieldName);
    }

    public JsonArray getArray(String fieldName) {
        return this.decrypt(fieldName).getArray(fieldName);
    }

    public JsonObject getObject(String fieldName) {
        return this.decrypt(fieldName).getObject(fieldName);
    }

    public String getString(String fieldName) {
        return this.decrypt(fieldName).getString(fieldName);
    }

    public Boolean getBoolean(String fieldName) {
        return this.decrypt(fieldName).getBoolean(fieldName);
    }

    public Integer getInt(String fieldName) {
        return this.decrypt(fieldName).getInt(fieldName);
    }

    public Long getLong(String fieldName) {
        return this.decrypt(fieldName).getLong(fieldName);
    }

    public Double getDouble(String fieldName) {
        return this.decrypt(fieldName).getDouble(fieldName);
    }

    public Number getNumber(String fieldName) {
        return this.decrypt(fieldName).getNumber(fieldName);
    }

    public BigDecimal getBigDecimal(String fieldName) {
        return this.decrypt(fieldName).getBigDecimal(fieldName);
    }

    public BigInteger getBigInteger(String fieldName) {
        return this.decrypt(fieldName).getBigInteger(fieldName);
    }

    public JsonObjectCrypto remove(String fieldName) {
        this.wrapped.removeKey(this.cryptoManager.mangle(fieldName));
        return this;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

