/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.json.JsonObject;
import java.util.Objects;

public class AnalyticsIndex {
    private final String name;
    private final boolean primary;
    private final String datasetName;
    private final String dataverseName;
    private final JsonObject raw;

    @Stability.Internal
    public AnalyticsIndex(JsonObject raw) {
        this.raw = Objects.requireNonNull(raw);
        this.name = raw.getString("IndexName");
        this.datasetName = raw.getString("DatasetName");
        this.dataverseName = raw.getString("DataverseName");
        this.primary = Boolean.TRUE.equals(raw.getBoolean("IsPrimary"));
    }

    public String name() {
        return this.name;
    }

    public boolean primary() {
        return this.primary;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public String dataverseName() {
        return this.dataverseName;
    }

    public JsonObject raw() {
        return this.raw;
    }

    public String toString() {
        return "AnalyticsIndex{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", primary=" + RedactableArgument.redactMeta((Object)this.primary) + ", datasetName='" + RedactableArgument.redactMeta((Object)this.datasetName) + '\'' + ", dataverseName='" + RedactableArgument.redactMeta((Object)this.dataverseName) + '\'' + ", raw=" + RedactableArgument.redactMeta((Object)this.raw) + '}';
    }
}

