/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.WkbUtil;
import com.datastax.shaded.esri.GeometryException;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCLineString;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public abstract class Geometry
implements Serializable {
    private static final long serialVersionUID = -3131471128157336656L;
    static final SpatialReference SPATIAL_REFERENCE_4326 = SpatialReference.create(4326);
    private final OGCGeometry ogcGeometry;

    static <T extends OGCGeometry> T fromOgcWellKnownText(String source, Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromText(source);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTypeException(e.getMessage());
        }
        Geometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    static <T extends OGCGeometry> T fromOgcWellKnownBinary(ByteBuffer source, Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromBinary(source);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidTypeException(e.getMessage());
        }
        Geometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    static <T extends OGCGeometry> T fromOgcGeoJson(String source, Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromGeoJson(source);
        }
        catch (Exception e) {
            throw new InvalidTypeException(e.getMessage());
        }
        Geometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    private static void validateType(OGCGeometry geometry, Class<? extends OGCGeometry> klass) {
        if (!geometry.getClass().equals(klass)) {
            throw new InvalidTypeException(String.format("%s is not of type %s", geometry.getClass().getSimpleName(), klass.getSimpleName()));
        }
    }

    Geometry(OGCGeometry ogcGeometry) {
        this.ogcGeometry = ogcGeometry;
        Preconditions.checkNotNull((Object)ogcGeometry);
        Geometry.validateOgcGeometry(ogcGeometry);
    }

    private static void validateOgcGeometry(OGCGeometry geometry) {
        try {
            if (geometry.is3D()) {
                throw new InvalidTypeException(String.format("'%s' is not 2D", geometry.asText()));
            }
            if (!geometry.isSimple()) {
                throw new InvalidTypeException(String.format("'%s' is not simple. Points and edges cannot self-intersect.", geometry.asText()));
            }
        }
        catch (GeometryException e) {
            throw new InvalidTypeException("Invalid geometry", (Throwable)e);
        }
    }

    static ImmutableList<Point> getPoints(OGCLineString lineString) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < lineString.numPoints(); ++i) {
            builder.add((Object)new Point(lineString.pointN(i)));
        }
        return builder.build();
    }

    OGCGeometry getOgcGeometry() {
        return this.ogcGeometry;
    }

    com.datastax.shaded.esri.Geometry getEsriGeometry() {
        return this.ogcGeometry.getEsriGeometry();
    }

    public String asWellKnownText() {
        return this.ogcGeometry.asText();
    }

    public ByteBuffer asWellKnownBinary() {
        return WkbUtil.asLittleEndianBinary(this.ogcGeometry);
    }

    public String asGeoJson() {
        return this.ogcGeometry.asGeoJson();
    }

    public boolean contains(Geometry other) {
        Preconditions.checkNotNull((Object)other);
        return this.getOgcGeometry().contains(other.getOgcGeometry());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geometry that = (Geometry)o;
        return this.getOgcGeometry().equals(that.getOgcGeometry());
    }

    public int hashCode() {
        return this.getEsriGeometry().hashCode();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public String toString() {
        return this.asWellKnownText();
    }
}

