/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Geometry;
import java.nio.ByteBuffer;

abstract class GeometryCodec<T extends Geometry>
extends TypeCodec<T> {
    protected GeometryCodec(DataType.CustomType cqlType, Class<T> javaType) {
        super((DataType)cqlType, javaType);
    }

    public T deserialize(ByteBuffer bb, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return bb == null || bb.remaining() == 0 ? null : (T)this.fromWellKnownBinary(bb.slice());
    }

    public ByteBuffer serialize(T geometry, ProtocolVersion protocolVersion) throws InvalidTypeException {
        return geometry == null ? null : this.toWellKnownBinary(geometry);
    }

    public T parse(String s) throws InvalidTypeException {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty() || s.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted((String)s)) {
            throw new InvalidTypeException("Geometry values must be enclosed by single quotes");
        }
        return this.fromWellKnownText(ParseUtils.unquote((String)s));
    }

    public String format(T geometry) throws InvalidTypeException {
        return geometry == null ? "NULL" : ParseUtils.quote((String)this.toWellKnownText(geometry));
    }

    protected abstract T fromWellKnownText(String var1);

    protected abstract T fromWellKnownBinary(ByteBuffer var1);

    protected abstract String toWellKnownText(T var1);

    protected abstract ByteBuffer toWellKnownBinary(T var1);
}

