/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.graph.DefaultGraphModule;
import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.DriverObjectsModule;
import com.datastax.driver.dse.graph.DseGraphDriverModule;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphSON2Mapper;
import com.datastax.driver.dse.graph.GremlinDateTimeModule;
import com.datastax.driver.dse.graph.GremlinDriverModule;
import com.datastax.driver.dse.graph.GremlinGraphDriverModule;
import com.datastax.driver.dse.graph.GremlinJavaTimeModule;
import com.datastax.driver.dse.graph.GremlinXDriverModule;
import com.datastax.driver.dse.graph.Jdk8Jsr310Module;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.driver.dse.graph.TinkerDriverModule;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphJsonUtils {
    private static final Logger LOGGER;
    private static final ObjectMapper GRAPHSON1_OBJECT_MAPPER;
    private static final ObjectMapper GRAPHSON2_OBJECT_MAPPER;
    public static final Function<Row, GraphNode> ROW_TO_GRAPHSON2_OBJECTGRAPHNODE;
    private static final boolean JSR_310_AVAILABLE;

    private static Version dseDriverVersion() {
        String versionStr = DseCluster.getDseDriverVersion();
        VersionNumber version = VersionNumber.parse((String)versionStr);
        return new Version(version.getMajor(), version.getMinor(), version.getPatch(), versionStr.contains("-SNAPSHOT") ? "SNAPSHOT" : null, "com.datastax.cassandra", "dse-driver");
    }

    static GraphNode readStringAsTree(String content) {
        try {
            return new DefaultGraphNode(GRAPHSON1_OBJECT_MAPPER.readTree(content), GRAPHSON1_OBJECT_MAPPER);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static String writeValueAsString(Object value) {
        try {
            return GRAPHSON1_OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static GraphNode readStringAsTreeGraphson20(String content) {
        try {
            return new ObjectGraphNode(GRAPHSON2_OBJECT_MAPPER.readValue(content, Object.class));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        boolean jsr310Available;
        LOGGER = LoggerFactory.getLogger(GraphJsonUtils.class);
        ROW_TO_GRAPHSON2_OBJECTGRAPHNODE = new Function<Row, GraphNode>(){

            public GraphNode apply(Row input) {
                try {
                    if (input == null) {
                        return null;
                    }
                    if (input.getColumnDefinitions().contains("gremlin")) {
                        return GraphJsonUtils.readStringAsTreeGraphson20(input.getString("gremlin")).get("result");
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new DriverException("Could not deserialize the response of this Graph query.", (Throwable)e);
                }
            }
        };
        try {
            Class.forName("java.time.Instant");
            jsr310Available = true;
        }
        catch (LinkageError e) {
            jsr310Available = false;
            LOGGER.warn("JSR 310 could not be loaded", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            jsr310Available = false;
        }
        JSR_310_AVAILABLE = jsr310Available;
        GRAPHSON1_OBJECT_MAPPER = new ObjectMapper();
        Version dseDriverVersion = GraphJsonUtils.dseDriverVersion();
        GRAPHSON1_OBJECT_MAPPER.registerModule(new DefaultGraphModule("graph-default", dseDriverVersion));
        GraphSON2Mapper.Builder graphSON2MapperBuilder = GraphSON2Mapper.build().addCustomModule(new GremlinDriverModule()).addCustomModule(new GremlinXDriverModule()).addCustomModule(new GremlinGraphDriverModule()).addCustomModule(new DseGraphDriverModule()).addCustomModule(new TinkerDriverModule()).addCustomModule(new DriverObjectsModule());
        if (JSR_310_AVAILABLE) {
            LOGGER.debug("JSR 310 found on the classpath, registering serializers for java.time temporal types");
            GRAPHSON1_OBJECT_MAPPER.registerModule(new Jdk8Jsr310Module("graph-jsr310", dseDriverVersion));
            graphSON2MapperBuilder.addCustomModule(new GremlinJavaTimeModule());
        } else {
            LOGGER.debug("JSR 310 not found on the classpath, not registering serializers for java.time temporal types");
            graphSON2MapperBuilder.addCustomModule(new GremlinDateTimeModule());
        }
        GRAPHSON2_OBJECT_MAPPER = graphSON2MapperBuilder.create().createMapper();
    }
}

