/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.RegularGraphStatement;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class SimpleGraphStatement
extends RegularGraphStatement {
    private final String query;
    private final Map<String, Object> valuesMap;
    private boolean needsRebuild = true;
    private SimpleStatement statement;
    private ConsistencyLevel nativeConsistencyLevel;
    private long defaultTimestamp = Long.MIN_VALUE;
    private volatile int readTimeoutMillis = Integer.MIN_VALUE;

    public SimpleGraphStatement(String query) {
        this(query, new HashMap<String, Object>());
    }

    public SimpleGraphStatement(String query, Map<String, Object> valuesMap) {
        Preconditions.checkNotNull(valuesMap, (Object)"Parameter valuesMap cannot be null");
        this.query = query;
        this.valuesMap = valuesMap;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    public SimpleGraphStatement set(String name, Object value) {
        this.valuesMap.put(name, value);
        this.needsRebuild = true;
        return this;
    }

    @Override
    public GraphStatement setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.needsRebuild = true;
        this.nativeConsistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.nativeConsistencyLevel;
    }

    @Override
    public GraphStatement setDefaultTimestamp(long defaultTimestamp) {
        this.needsRebuild = true;
        this.defaultTimestamp = defaultTimestamp;
        return this;
    }

    @Override
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public GraphStatement setReadTimeoutMillis(int readTimeoutMillis) {
        Preconditions.checkArgument((readTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"read timeout must be >= 0");
        this.readTimeoutMillis = readTimeoutMillis;
        this.needsRebuild = true;
        return this;
    }

    @Override
    public long getDefaultTimestamp() {
        return this.defaultTimestamp;
    }

    public SimpleStatement unwrap() {
        this.maybeRebuildCache();
        return this.statement;
    }

    private void maybeRebuildCache() {
        if (this.needsRebuild) {
            if (this.valuesMap.isEmpty()) {
                this.statement = new SimpleStatement(this.query);
            } else {
                String values = GraphJsonUtils.writeValueAsString(this.valuesMap);
                this.statement = new SimpleStatement(this.query, new Object[]{values});
            }
            if (this.getConsistencyLevel() != null) {
                this.statement.setConsistencyLevel(this.nativeConsistencyLevel);
            }
            if (this.getDefaultTimestamp() != Long.MIN_VALUE) {
                this.statement.setDefaultTimestamp(this.defaultTimestamp);
            }
            if (this.getReadTimeoutMillis() != Integer.MIN_VALUE) {
                this.statement.setReadTimeoutMillis(this.readTimeoutMillis);
            }
            this.needsRebuild = false;
        }
    }
}

