/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.InternalUtils;
import com.datastax.shaded.esri.MultiVertexGeometryImpl;
import com.datastax.shaded.esri.OperatorIntersection;
import com.datastax.shaded.esri.OperatorIntersectionCursor;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.RasterizedGeometry2D;
import com.datastax.shaded.esri.SimpleGeometryCursor;
import com.datastax.shaded.esri.SpatialReference;

class OperatorIntersectionLocal
extends OperatorIntersection {
    OperatorIntersectionLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, GeometryCursor intersector, SpatialReference sr, ProgressTracker progressTracker) {
        return new OperatorIntersectionCursor(inputGeometries, intersector, sr, progressTracker, -1);
    }

    @Override
    public GeometryCursor execute(GeometryCursor input_geometries, GeometryCursor intersector, SpatialReference sr, ProgressTracker progress_tracker, int dimensionMask) {
        return new OperatorIntersectionCursor(input_geometries, intersector, sr, progress_tracker, dimensionMask);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, Geometry intersector, SpatialReference sr, ProgressTracker progressTracker) {
        SimpleGeometryCursor inputGeomCurs = new SimpleGeometryCursor(inputGeometry);
        SimpleGeometryCursor intersectorCurs = new SimpleGeometryCursor(intersector);
        GeometryCursor geometryCursor = this.execute(inputGeomCurs, intersectorCurs, sr, progressTracker);
        return geometryCursor.next();
    }

    @Override
    public boolean accelerateGeometry(Geometry geometry, SpatialReference spatialReference, Geometry.GeometryAccelerationDegree accelDegree) {
        if (!this.canAccelerateGeometry(geometry)) {
            return false;
        }
        double tol = InternalUtils.calculateToleranceFromGeometry(spatialReference, geometry, false);
        boolean accelerated = ((MultiVertexGeometryImpl)geometry._getImpl())._buildQuadTreeAccelerator(accelDegree);
        return accelerated |= ((MultiVertexGeometryImpl)geometry._getImpl())._buildRasterizedGeometryAccelerator(tol, accelDegree);
    }

    @Override
    public boolean canAccelerateGeometry(Geometry geometry) {
        return RasterizedGeometry2D.canUseAccelerator(geometry);
    }
}

