/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.VertexDescription;
import com.datastax.shaded.esri.VertexDescriptionHash;
import java.util.Arrays;

class VertexDescriptionDesignerImpl
extends VertexDescription {
    protected boolean m_bModified;

    public VertexDescriptionDesignerImpl() {
        this.m_semantics = new int[10];
        this.m_semantics[0] = 0;
        this.m_attributeCount = 1;
        this.m_semanticsToIndexMap = new int[10];
        for (int i = 0; i < 10; ++i) {
            this.m_semanticsToIndexMap[i] = -1;
        }
        this.m_semanticsToIndexMap[this.m_semantics[0]] = 0;
        this.m_bModified = true;
    }

    public VertexDescriptionDesignerImpl(VertexDescription other) {
        super(other.hashCode(), other);
        this.m_bModified = true;
    }

    public void addAttribute(int semantics) {
        if (this.hasAttribute(semantics)) {
            return;
        }
        this.m_semanticsToIndexMap[semantics] = 0;
        this._initMapping();
    }

    void removeAttribute(int semantics) {
        if (semantics == 0) {
            throw new IllegalArgumentException("Position attribue cannot be removed");
        }
        if (!this.hasAttribute(semantics)) {
            return;
        }
        this.m_semanticsToIndexMap[semantics] = -1;
        this._initMapping();
    }

    public void reset() {
        this.m_semantics[0] = 0;
        this.m_attributeCount = 1;
        for (int i : this.m_semanticsToIndexMap) {
            this.m_semanticsToIndexMap[i] = -1;
        }
        this.m_semanticsToIndexMap[this.m_semantics[0]] = 0;
        this.m_bModified = true;
    }

    public VertexDescription getDescription() {
        VertexDescriptionHash vdhash = VertexDescriptionHash.getInstance();
        VertexDescriptionDesignerImpl vdd = this;
        return vdhash.add(vdd);
    }

    static VertexDescription getDefaultDescriptor2D() {
        VertexDescriptionHash vdhash = VertexDescriptionHash.getInstance();
        VertexDescription vd = vdhash.getVD2D();
        return vd;
    }

    static VertexDescription getDefaultDescriptor3D() {
        VertexDescriptionHash vdhash = VertexDescriptionHash.getInstance();
        VertexDescription vd = vdhash.getVD3D();
        return vd;
    }

    VertexDescription _createInternal() {
        int hash = this.hashCode();
        VertexDescription vd = new VertexDescription(hash, this);
        return vd;
    }

    protected void _initMapping() {
        this.m_attributeCount = 0;
        int j = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.m_semanticsToIndexMap[i] < 0) continue;
            this.m_semantics[j] = i;
            this.m_semanticsToIndexMap[i] = j++;
            ++this.m_attributeCount;
        }
        this.m_bModified = true;
    }

    @Override
    public int hashCode() {
        if (this.m_bModified) {
            this.m_hash = this.calculateHashImpl();
            this.m_bModified = false;
        }
        return this.m_hash;
    }

    @Override
    public boolean equals(Object _other) {
        if (_other == null) {
            return false;
        }
        if (_other == this) {
            return true;
        }
        if (_other.getClass() != this.getClass()) {
            return false;
        }
        VertexDescriptionDesignerImpl other = (VertexDescriptionDesignerImpl)_other;
        if (other.getAttributeCount() != this.getAttributeCount()) {
            return false;
        }
        for (int i = 0; i < this.m_attributeCount; ++i) {
            if (this.m_semantics[i] == other.m_semantics[i]) continue;
            return false;
        }
        return this.m_bModified == other.m_bModified;
    }

    public boolean isDesignerFor(VertexDescription vd) {
        if (vd.getAttributeCount() != this.getAttributeCount()) {
            return false;
        }
        for (int i = 0; i < this.m_attributeCount; ++i) {
            if (this.m_semantics[i] == vd.m_semantics[i]) continue;
            return false;
        }
        return true;
    }

    static int[] mapAttributes(VertexDescription src, VertexDescription dest) {
        int[] srcToDst = new int[src.getAttributeCount()];
        Arrays.fill(srcToDst, -1);
        int nsrc = src.getAttributeCount();
        for (int i = 0; i < nsrc; ++i) {
            srcToDst[i] = dest.getAttributeIndex(src.getSemantics(i));
        }
        return srcToDst;
    }

    static VertexDescription getMergedVertexDescription(VertexDescription src, int semanticsToAdd) {
        VertexDescriptionDesignerImpl vdd = new VertexDescriptionDesignerImpl(src);
        vdd.addAttribute(semanticsToAdd);
        return vdd.getDescription();
    }

    static VertexDescription getMergedVertexDescription(VertexDescription d1, VertexDescription d2) {
        VertexDescriptionDesignerImpl vdd = null;
        for (int semantics = 0; semantics < 10; ++semantics) {
            if (d1.hasAttribute(semantics) || !d2.hasAttribute(semantics)) continue;
            if (vdd == null) {
                vdd = new VertexDescriptionDesignerImpl(d1);
            }
            vdd.addAttribute(semantics);
        }
        if (vdd != null) {
            return vdd.getDescription();
        }
        return d1;
    }

    static VertexDescription removeSemanticsFromVertexDescription(VertexDescription src, int semanticsToRemove) {
        VertexDescriptionDesignerImpl vdd = new VertexDescriptionDesignerImpl(src);
        vdd.removeAttribute(semanticsToRemove);
        return vdd.getDescription();
    }
}

