/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.MultiPath;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCCurve;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCMultiLineString;
import com.datastax.shaded.esri.ogc.OGCPoint;
import java.nio.ByteBuffer;

public class OGCLineString
extends OGCCurve {
    MultiPath multiPath = new Polyline();

    public int numPoints() {
        if (this.multiPath.isEmpty()) {
            return 0;
        }
        int d = this.multiPath.isClosedPath(0) ? 1 : 0;
        return this.multiPath.getPointCount() + d;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 4);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(4, this.getEsriGeometry(), null);
    }

    public OGCPoint pointN(int n) {
        int nn = this.multiPath.isClosedPath(0) && n == this.multiPath.getPathSize(0) ? this.multiPath.getPathStart(0) : n + this.multiPath.getPathStart(0);
        return (OGCPoint)OGCGeometry.createFromEsriGeometry(this.multiPath.getPoint(nn), this.esriSR);
    }

    @Override
    public boolean isClosed() {
        return this.multiPath.isClosedPathInXYPlane(0);
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, true);
        }
        this.esriSR = sr;
    }

    public OGCLineString(MultiPath mp, int pathIndex, SpatialReference sr, boolean reversed) {
        if (!mp.isEmpty()) {
            this.multiPath.addPath(mp, pathIndex, !reversed);
        }
        this.esriSR = sr;
    }

    @Override
    public double length() {
        return this.multiPath.calculateLength2D();
    }

    @Override
    public OGCPoint startPoint() {
        return this.pointN(0);
    }

    @Override
    public OGCPoint endPoint() {
        return this.pointN(this.numPoints() - 1);
    }

    @Override
    public String geometryType() {
        return "LineString";
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.multiPath;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiLineString((Polyline)this.multiPath, this.esriSR);
    }
}

