/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.MultiPoint;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCMultiPoint;
import java.nio.ByteBuffer;

public final class OGCPoint
extends OGCGeometry {
    Point point;

    public OGCPoint(Point pt, SpatialReference sr) {
        this.point = pt;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 1);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(1, this.getEsriGeometry(), null);
    }

    public double X() {
        return this.point.getX();
    }

    public double Y() {
        return this.point.getY();
    }

    public double Z() {
        return this.point.getZ();
    }

    public double M() {
        return this.point.getM();
    }

    @Override
    public String geometryType() {
        return "Point";
    }

    @Override
    public OGCGeometry boundary() {
        return new OGCMultiPoint(new MultiPoint(this.getEsriGeometry().getDescription()), this.esriSR);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.point;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiPoint(this.point, this.esriSR);
    }
}

