/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.api.predicates;

import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.dse.graph.internal.GeoPredicate;
import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;

public class Geo {
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private static final double EARTH_MEAN_RADIUS_KM = 6371.0087714;
    private static final double DEG_TO_KM = 111.19507973436875;
    private static final double KM_TO_DEG = 0.008993203677616635;
    private static final double KM_TO_MILES = 0.621371192;
    private static final double MILES_TO_KM = 1.6093440006146922;

    public static P<Object> inside(Point center, double radius, Unit units) {
        return new P((BiPredicate)GeoPredicate.inside, (Object)Geo.distance(center, units.toDegrees(radius)));
    }

    public static P<Object> inside(Point center, double radius) {
        return new P((BiPredicate)GeoPredicate.insideCartesian, (Object)Geo.distance(center, radius));
    }

    public static P<Object> inside(Polygon polygon) {
        return new P((BiPredicate)GeoPredicate.insideCartesian, (Object)polygon);
    }

    public static Point point(double x, double y) {
        return new Point(x, y);
    }

    public static LineString lineString(double ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("lineString() must be passed an even number of arguments");
        }
        if (points.length <= 0) {
            throw new IllegalArgumentException("lineString() must be passed at least two arguments");
        }
        StringBuilder sb = new StringBuilder("LINESTRING(");
        for (int i = 0; i < points.length; i += 2) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(points[i]);
            sb.append(" ");
            sb.append(points[i + 1]);
        }
        sb.append(")");
        return LineString.fromWellKnownText((String)sb.toString());
    }

    public static Polygon polygon(double ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("polygon() must be passed an even number of arguments");
        }
        if (points.length <= 0) {
            throw new IllegalArgumentException("polygon() must be passed at least two arguments");
        }
        StringBuilder sb = new StringBuilder("POLYGON((");
        for (int i = 0; i < points.length; i += 2) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(points[i]);
            sb.append(" ");
            sb.append(points[i + 1]);
        }
        sb.append("))");
        return Polygon.fromWellKnownText((String)sb.toString());
    }

    private static Distance distance(Point center, double radius) {
        Preconditions.checkArgument((center != null ? 1 : 0) != 0, (Object)"Invalid center point");
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (String)"Invalid radius: %s", (Object[])new Object[]{radius});
        return new Distance(center, radius);
    }

    public static enum Unit {
        MILES(0.014473158384878317),
        KILOMETERS(0.008993203677616635),
        METERS(8.993203677616634E-6),
        DEGREES(1.0);

        private double multiplier;

        private Unit(double multiplier) {
            this.multiplier = multiplier;
        }

        public double toDegrees(double distance) {
            return distance * this.multiplier;
        }
    }
}

