/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.internal;

import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.dse.graph.internal.DseRemoteTraversal;
import com.datastax.dse.graph.internal.utils.GraphSONUtils;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

public class DseRemoteConnection
implements RemoteConnection {
    private final DseSession dseSession;
    private final GraphOptions graphOptions;

    private DseRemoteConnection(Builder builder) {
        this.dseSession = builder.dseSession;
        this.graphOptions = builder.graphOptions;
    }

    public static Builder builder(DseSession dseSession) {
        return new Builder(dseSession);
    }

    public <E> Iterator<Traverser.Admin<E>> submit(Traversal<?, E> traversal) throws RemoteConnectionException {
        return this.submit(traversal.asAdmin().getBytecode());
    }

    public <E> RemoteTraversal<?, E> submit(Bytecode bytecode) throws RemoteConnectionException {
        try {
            return this.submitAsync(bytecode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RemoteConnectionException((Throwable)e);
        }
    }

    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        GraphStatement graphStatement = GraphSONUtils.getStatementFromBytecodeRemoteSource(bytecode);
        this.applyGraphOptionsOnStatement(graphStatement, this.graphOptions);
        ListenableFuture listenableFutureResults = this.dseSession.executeGraphAsync(graphStatement);
        return DseRemoteConnection.buildCompletableFutureResultSet((ListenableFuture<GraphResultSet>)listenableFutureResults).thenApply(DseRemoteTraversal::new);
    }

    private static CompletableFuture<GraphResultSet> buildCompletableFutureResultSet(final ListenableFuture<GraphResultSet> listenableFuture) {
        final CompletableFuture<GraphResultSet> completable = new CompletableFuture<GraphResultSet>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = listenableFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<GraphResultSet>(){

            public void onSuccess(GraphResultSet result) {
                completable.complete(result);
            }

            public void onFailure(Throwable t) {
                completable.completeExceptionally(t);
            }
        });
        return completable;
    }

    public void close() throws Exception {
    }

    private void applyGraphOptionsOnStatement(GraphStatement graphStatement, GraphOptions graphOptions) {
        if (graphOptions == null) {
            return;
        }
        if (graphOptions.getGraphName() != null) {
            graphStatement.setGraphName(graphOptions.getGraphName());
        }
        if (graphOptions.getGraphReadConsistencyLevel() != null) {
            graphStatement.setGraphReadConsistencyLevel(graphOptions.getGraphReadConsistencyLevel());
        }
        if (graphOptions.getGraphWriteConsistencyLevel() != null) {
            graphStatement.setGraphWriteConsistencyLevel(graphOptions.getGraphWriteConsistencyLevel());
        }
        if (graphOptions.getGraphSource() != null) {
            graphStatement.setGraphSource(graphOptions.getGraphSource());
        }
        if (graphOptions.getReadTimeoutMillis() != 0) {
            graphStatement.setReadTimeoutMillis(graphOptions.getReadTimeoutMillis());
        }
    }

    public static class Builder {
        private final DseSession dseSession;
        private GraphOptions graphOptions;

        private Builder(DseSession dseSession) {
            this.dseSession = dseSession;
        }

        public Builder withGraphOptions(GraphOptions graphOptions) {
            this.graphOptions = graphOptions;
            return this;
        }

        public DseRemoteConnection build() {
            return new DseRemoteConnection(this);
        }
    }
}

