package com.dji.wpmzsdk.common.data;

import dji.sdk.wpmz.value.mission.WaylineMissionConfigParseInfo;
import dji.sdk.wpmz.value.mission.WaylineMissionParseInfo;
import dji.sdk.wpmz.value.mission.WaylineWaylinesParseInfo;

/**
 * 更多了解请参考: https://developer.dji.com/doc/cloud-api-tutorial/cn/feature-set/dji-wpml/overview.html
 * KMZInfo 包含了已开放等所有字段
 *
 */
public class KMZInfo {

    /**
     * 任务创建信息 包含kmz创建时间，更新时间等
     */
    private WaylineMissionParseInfo waylineMissionParseInfo;

    /**
     * 任务信息 参考文档中missionConfig字段
     */
    private WaylineMissionConfigParseInfo waylineMissionConfigParseInfo;

    /**
     * 航点飞行的模板信息,为用户编辑和规划航线提供了一种便捷手段目前只开放航点飞行
     * 参考 https://developer.dji.com/doc/cloud-api-tutorial/cn/feature-set/dji-wpml/template-kml.html
     */
    private TemplateParseInfo waylineTemplatesParseInfo;

    /**
     * 飞机最终执行的任务信息,也可通过模版信息生成
     *  包含任务信息，航线信息，航点信息 参考 https://developer.dji.com/doc/cloud-api-tutorial/cn/feature-set/dji-wpml/waylines-wpml.html
     */
    private WaylineWaylinesParseInfo waylineWaylinesParseInfo;

    /**
     * 获取航线概要信息
     */
    public WaylineMissionParseInfo getWaylineMissionParseInfo() {
        return waylineMissionParseInfo;
    }


    public void setWaylineMissionParseInfo(WaylineMissionParseInfo waylineMissionParseInfo) {
        this.waylineMissionParseInfo = waylineMissionParseInfo;
    }

    /**
     * 获取航线全局信息
     * @return
     */
    public WaylineMissionConfigParseInfo getWaylineMissionConfigParseInfo() {
        return waylineMissionConfigParseInfo;
    }

    public void setWaylineMissionConfigParseInfo(WaylineMissionConfigParseInfo waylineMissionConfigParseInfo) {
        this.waylineMissionConfigParseInfo = waylineMissionConfigParseInfo;
    }

    /**
     * 获取航线Template信息
     * @return
     */
    public TemplateParseInfo getWaylineTemplatesParseInfo() {
        return waylineTemplatesParseInfo;
    }

    public void setWaylineTemplatesParseInfo(TemplateParseInfo waylineTemplatesParseInfo) {
        this.waylineTemplatesParseInfo = waylineTemplatesParseInfo;
    }

    /**
     * 获取航线Wayline信息
     * @return
     */
    public WaylineWaylinesParseInfo getWaylineWaylinesParseInfo() {
        return waylineWaylinesParseInfo;
    }

    public void setWaylineWaylinesParseInfo(WaylineWaylinesParseInfo waylineWaylinesParseInfo) {
        this.waylineWaylinesParseInfo = waylineWaylinesParseInfo;
    }




}
