package com.dji.wpmzsdk.common.utils

import com.dji.wpmzsdk.common.data.Template
import com.dji.wpmzsdk.common.data.TemplateParseInfo
import dji.sdk.wpmz.value.mission.WaylineTemplate
import dji.sdk.wpmz.value.mission.WaylineTemplateType
import dji.sdk.wpmz.value.mission.WaylineTemplatesParseInfo

/**
 * @author feel.feng
 * @time 2023/06/28 11:17 上午
 * @description:
 */
 object TemplateTransform {

     fun transToWaylineTemplate(template: Template): WaylineTemplate? {
        val waylineTemplate = WaylineTemplate()
        waylineTemplate.templateType = WaylineTemplateType.WAYPOINT
        waylineTemplate.templateId = template.templateId
        waylineTemplate.autoFlightSpeed = template.autoFlightSpeed
        waylineTemplate.coordinateParam = template.coordinateParam
        waylineTemplate.transitionalSpeed = template.transitionalSpeed
        waylineTemplate.waypointInfo = template.waypointInfo
        waylineTemplate.payloadParam = template.payloadParam
        waylineTemplate.useGlobalTransitionalSpeed = template.useGlobalTransitionalSpeed
        return waylineTemplate
    }

    fun transFromWaylineTemplate(waylineTemplate: WaylineTemplate) :Template?{
        val template = Template()
        template.templateId = waylineTemplate.templateId
        template.autoFlightSpeed = waylineTemplate.autoFlightSpeed
        template.coordinateParam = waylineTemplate.coordinateParam
        template.transitionalSpeed = waylineTemplate.transitionalSpeed
        template.waypointInfo = waylineTemplate.waypointInfo
        template.payloadParam = waylineTemplate.payloadParam
        template.useGlobalTransitionalSpeed = waylineTemplate.useGlobalTransitionalSpeed
        return template
    }

    fun transTemplateParseInfo(WaylineTemplatesParseInfo: WaylineTemplatesParseInfo) : TemplateParseInfo{
       val  templateParseInfo = TemplateParseInfo()
        templateParseInfo.error = WaylineTemplatesParseInfo.error
        WaylineTemplatesParseInfo.templates.forEach {
            templateParseInfo.templates.add(transFromWaylineTemplate(it))
        }

        return templateParseInfo

    }
}