package com.dji.wpmzsdk.common.utils.kml;

import com.dji.wpmzsdk.common.utils.kml.model.CameraType;
import com.dji.wpmzsdk.common.utils.kml.model.WaypointDroneType;

/**
 * 飞机类型（主要通过 WaypointDroneType 进行区分）
 * @author young.huang
 */
public class DroneTypeUtils {

    private DroneTypeUtils() {

    }

    public static boolean isPM430OrPM431(WaypointDroneType droneType) {
        return droneType == WaypointDroneType.PM430 || droneType == WaypointDroneType.PM431;
    }

    /**
     * 320 类型
     * @param droneType
     * @return
     */
    public static boolean isPM320(WaypointDroneType droneType) {
        return droneType == WaypointDroneType.PM320 || droneType == WaypointDroneType.PM320_T_RTK;
    }

    public static boolean isModernDroneSerial(WaypointDroneType droneType) {
        return droneType == WaypointDroneType.PM430
                || droneType == WaypointDroneType.PM431
                || droneType == WaypointDroneType.PM320
                || droneType == WaypointDroneType.PM320_T_RTK
                || droneType == WaypointDroneType.WM265_E
                || droneType == WaypointDroneType.WM265_M
                || droneType == WaypointDroneType.WM265_T;
    }

    public static boolean isWM265(WaypointDroneType droneType) {
        return droneType == WaypointDroneType.WM265_E
                || droneType == WaypointDroneType.WM265_T
                || droneType == WaypointDroneType.WM265_M;
    }

    public static boolean isPM430(WaypointDroneType droneType) {
        return droneType == WaypointDroneType.PM430;
    }

    //m todo

//    public static WaypointDroneType getDroneType() {
//        if (ProductUtil.isPM430()) {
//            return WaypointDroneType.PM430;
//        } else if (ProductUtil.isPM431()) {
//            return WaypointDroneType.PM431;
//        }
//        final CameraType cameraType = Pilot2Repo.Camera().CameraType().getValue(CameraType.UNKNOWN);
//        switch (cameraType) {
//            case DJICameraTypePM320DualLight:
//                return WaypointDroneType.PM320;
//            case DJICameraTypePM320TripleLight:
//                return WaypointDroneType.PM320_T_RTK;
//            case WM265_E:
//                return WaypointDroneType.WM265_E;
//            case WM265_T:
//                return WaypointDroneType.WM265_T;
//            case WM265_M:
//                return WaypointDroneType.WM265_M;
//            default:
//                return WaypointDroneType.PM430;
//        }
//    }
}
